/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.upreg;

import de.intarsys.security.app.AuthenticationCanceled;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.common.CommonSecurityApplication;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.upreg.BareBoneSigner;
import de.intarsys.security.device.upreg.Conversations;
import de.intarsys.security.device.upreg.PACKAGE;
import de.intarsys.security.device.upreg.ParameterizedUPRegSigner;
import de.intarsys.security.device.upreg.UPRegDevice;
import de.intarsys.security.device.upreg.client.HashAlgorithm;
import de.intarsys.security.device.upreg.client.TokenPair;
import de.intarsys.security.device.upreg.client.UPRegServiceClient;
import de.intarsys.security.device.upreg.client.UPRegServiceException;
import de.intarsys.security.device.upreg.service.AuthenticateRequest;
import de.intarsys.security.method.common.signature.SignatureOptions;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.ISignatureDataList;
import de.intarsys.security.signature.common.IToBeSignedData;
import de.intarsys.security.signature.common.SignatureDataList;
import de.intarsys.security.signature.etsi.api.SignatureFormat;
import de.intarsys.tools.conversation.ConversationRegistry;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IReplyStage;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.conversation.impl.HttpRedirectStage;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.jaxrs.RequestContext;
import de.intarsys.tools.message.IMessageBundle;
import jakarta.ws.rs.ProcessingException;
import java.net.URI;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UPRegSigner
extends CommonSecurityApplication
implements ISigner {
    public static final String ARG_CANTON = "canton";
    public static final String ARG_DOMAIN = "domain";
    public static final Collection<String> SUPPORTED_HASH_ALGORITHM_NAMES = Stream.of(HashAlgorithm.values()).map(HashAlgorithm::getName).collect(Collectors.toUnmodifiableSet());
    private static final String PREFERRED_HASH_ALGORITHM_NAME = HashAlgorithm.SHA3_256.getName();
    private static final String AUTHENTICATION_START_PATH = "upreg/start-authentication.html";
    private static final String AUTHENTICATION_SUCCESS = "1";
    private static final String AUTHENTICATION_CANCELED = "2";
    private static final String AUTHENTICATION_ERROR = "3";
    private static final IMessageBundle Messages = PACKAGE.Messages;
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private List<ParameterizedUPRegSigner> children = new ArrayList<ParameterizedUPRegSigner>();
    private UPRegDevice device;
    private String canton;
    private String domain;
    private int approximatedContainerSize;
    private boolean batchMode;
    private IConversation<Void> rootConversation;
    private IConversation<Void> whenAuthenticated;

    public UPRegSigner(UPRegDevice device) {
        super((CommonDevice)device);
        this.device = device;
        this.rootConversation = new Conversation(this.toString() + "-root");
        this.whenAuthenticated = this.rootConversation.thenCompose(nothing -> {
            int signatureCount = this.children.size();
            List<TokenPair> tokenPairs = this.startTransactions(signatureCount);
            return this.authenticate(tokenPairs);
        }).thenAccept(this::assignZbTokens);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignZbTokens(List<TokenPair> tokenPairs) {
        this.logger.trace("{}: assignZbTokens()", (Object)this);
        Iterator<TokenPair> tokenPairIterator = tokenPairs.iterator();
        Object object = this.lock;
        synchronized (object) {
            this.children.forEach(child -> child.assignZbToken(((TokenPair)tokenPairIterator.next()).getZbToken()));
        }
    }

    private IConversation<List<TokenPair>> authenticate(List<TokenPair> tokenPairs) {
        this.logger.trace("{}: authenticate()", (Object)this);
        Conversation conversation = new Conversation(this.toString() + "-authenticate");
        conversation.setReplyStage((IReplyStage)new HttpRedirectStage(this.getAuthenticationRedirectUri((IConversation<?>)conversation), false, false));
        List<String> authTokens = tokenPairs.stream().map(TokenPair::getAuthToken).toList();
        String sessionId = conversation.getHandle();
        Conversations.setAuthenticateRequest(conversation, new AuthenticateRequest(this.getServiceClient().getAuthenticateEndpoint(), authTokens, this.domain, this.canton, this.device.getProviderId(), sessionId, this.device.getCallbackPort()));
        ConversationRegistry.publishForLifetime((IConversation)conversation);
        this.logger.trace("{}: published {} for redirection", (Object)this, (Object)conversation);
        return conversation.thenApply(response -> {
            if (!sessionId.equals(response.getProviderSessionId())) {
                throw new SecurityApplicationException(Messages.getString("UPRegSigner.invalidAuthenticationResponse", new Object[0]));
            }
            this.logger.trace("{}: authentication finished -> {}", (Object)this, (Object)response.getReturnCode());
            switch (response.getReturnCode()) {
                case "1": {
                    break;
                }
                case "2": {
                    throw new AuthenticationCanceled(Messages.getString("UPRegSigner.authenticationCanceledByUser", new Object[0]));
                }
                case "3": {
                    throw new SecurityApplicationException(Messages.getString("UPRegSigner.authenticationError", new Object[]{response.getMessage()}));
                }
                default: {
                    throw new SecurityApplicationException(Messages.getString("UPRegDocumentSigner.unknownAuthenticationResult", new Object[0]));
                }
            }
            return tokenPairs;
        });
    }

    public void buildCertificatePath() {
    }

    private IConversation<ISignatureDataList> commit() {
        ArrayList signatures = new ArrayList();
        IConversation conversation = Conversation.completed(null);
        for (ParameterizedUPRegSigner child : this.children) {
            conversation = conversation.thenCompose(nothing -> child.whenSigned()).thenAccept(signatures::add);
        }
        return conversation.thenApply(nothing -> {
            this.logger.trace("{}: commit() -> success", (Object)this);
            this.licenseReserve(signatures.size());
            this.licenseBookingCommit();
            this.publishOk();
            this.disposeChildren();
            return SignatureDataList.create((List)signatures);
        }).exceptionally(exception -> {
            this.logger.trace("{}: commit() -> fail", (Object)this, exception);
            this.licenseBookingAbort();
            if (ExceptionTools.isCancellation((Throwable)exception)) {
                this.publishCancel();
            } else {
                this.publishFail((Throwable)exception);
            }
            this.sendNotificationFailed((Throwable)exception);
            this.failChildren((Throwable)exception);
            this.disposeChildren();
            throw Conversation.rethrowable((Throwable)exception);
        });
    }

    IConversation<?> commitIfNecessary() {
        return this.batchMode ? Conversation.completed(null) : this.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParameterizedUPRegSigner createChild(String name, byte[] lastSignature, IDigest signedDigest, int signedRevision) {
        ParameterizedUPRegSigner child;
        Object object = this.lock;
        synchronized (object) {
            child = new ParameterizedUPRegSigner(this, name, lastSignature, signedDigest, signedRevision);
            this.children.add(child);
        }
        this.logger.trace("{}: createChild() -> {}", (Object)this, (Object)child);
        if (!this.batchMode) {
            this.start();
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeChildren() {
        Object object = this.lock;
        synchronized (object) {
            this.children.forEach(BareBoneSigner::dispose);
            this.children.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failChildren(Throwable throwable) {
        Object object = this.lock;
        synchronized (object) {
            this.children.forEach(child -> child.fail(throwable));
        }
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return null;
    }

    public int getApproximatedContainerSize() {
        return this.approximatedContainerSize;
    }

    public void setApproximatedContainerSize(int approximatedContainerSize) {
        this.approximatedContainerSize = approximatedContainerSize;
    }

    private URI getAuthenticationRedirectUri(IConversation<?> conversation) {
        return RequestContext.get().getUriBuilderContext().path(AUTHENTICATION_START_PATH).queryParam("state", new Object[]{conversation.getHandle()}).build(new Object[0]);
    }

    public String getCanton() {
        return this.canton;
    }

    public IX509PublicKeyCertificate[] getCertificatePath() {
        return null;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getEncryptionAlgorithmName() {
        return "RSA";
    }

    public String getHashAlgorithmName() {
        return null;
    }

    public String getPreferredHashAlgorithmName() {
        return PREFERRED_HASH_ALGORITHM_NAME;
    }

    public IPrincipal getPrincipal() {
        return null;
    }

    protected String getPublishCodePrefix() {
        return "sign";
    }

    public UPRegServiceClient getServiceClient() {
        return this.device.getServiceClient();
    }

    public SignatureFormat getSignatureFormat() {
        return null;
    }

    public Collection<String> getSupportedHashAlgorithmNames() {
        return SUPPORTED_HASH_ALGORITHM_NAMES;
    }

    public boolean isBasic() {
        return false;
    }

    public void setCanton(String canton) {
        this.canton = canton;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setHashAlgorithmName(String name) throws SecurityApplicationException {
    }

    public void setSignatureFormat(SignatureFormat value) {
    }

    public void setSignatureOptions(SignatureOptions options) {
    }

    public IConversation<ISignatureData> sign(IToBeSignedData data) {
        return Conversation.failed((Throwable)new UnsupportedOperationException("Can only sign via child signer"));
    }

    public IConversation<Void> signAbort() {
        this.logger.trace("{}: signAbort()", (Object)this);
        if (!this.batchMode) {
            return Conversation.failed((Throwable)new SecurityApplicationException("Not in batch mode"));
        }
        this.disposeChildren();
        return Conversation.completed(null);
    }

    public IConversation<Void> signBegin() {
        this.logger.trace("{}: signBegin()", (Object)this);
        this.batchMode = true;
        return Conversation.completed(null);
    }

    public IConversation<ISignatureDataList> signCommit() {
        this.logger.trace("{}: signCommit()", (Object)this);
        this.start();
        return this.commit();
    }

    public IConversation<Void> signPrepare() {
        this.logger.trace("{}: signPrepare()", (Object)this);
        return Conversation.completed(null);
    }

    private void start() {
        this.rootConversation.complete(null);
    }

    private List<TokenPair> startTransactions(int count) throws SecurityApplicationException {
        this.logger.trace("{}: startTransactions()", (Object)this);
        try {
            return this.getServiceClient().startTransactions(count);
        }
        catch (UPRegServiceException | ProcessingException exception) {
            throw new SecurityApplicationException(Messages.getString("UPRegSigner.failedToStartTransactions", new Object[0]), exception);
        }
    }

    IConversation<Void> whenAuthenticated() {
        return this.whenAuthenticated;
    }
}

