/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.upreg.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.io.IOException;
import java.util.HexFormat;

public class ByteArrayHexDeserializer
extends StdScalarDeserializer<byte[]> {
    protected ByteArrayHexDeserializer() {
        super(byte[].class);
    }

    public LogicalType logicalType() {
        return LogicalType.Binary;
    }

    public byte[] deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        String value = parser.getValueAsString();
        try {
            return HexFormat.of().parseHex(value);
        }
        catch (IllegalArgumentException exception) {
            return (byte[])context.handleWeirdStringValue(this.handledType(), value, "Malformed hex string", new Object[0]);
        }
    }
}

