/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.upreg.client;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.util.HexFormat;

public class ByteArrayHexSerializer
extends StdScalarSerializer<byte[]> {
    public ByteArrayHexSerializer() {
        super(byte[].class);
    }

    public void serialize(byte[] value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        String hexString = HexFormat.of().formatHex(value);
        generator.writeString(hexString);
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor arrayVisitor = visitor.expectArrayFormat(typeHint);
        if (arrayVisitor != null) {
            arrayVisitor.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

