/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.upreg.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.intarsys.security.device.upreg.client.ByteArrayHexSerializer;
import de.intarsys.security.device.upreg.client.HashAlgorithm;
import java.util.Base64;

public class Hash {
    @JsonProperty(value="algorithm")
    private HashAlgorithm algorithm;
    @JsonProperty(value="value")
    @JsonSerialize(using=ByteArrayHexSerializer.class)
    private byte[] value;

    public Hash(HashAlgorithm algorithm, byte[] value) {
        this.algorithm = algorithm;
        this.value = value;
    }

    public byte[] getValue() {
        return this.value;
    }

    public HashAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public String toString() {
        String base64Value = this.value == null ? null : Base64.getEncoder().encodeToString(this.value);
        return String.format("%s:%s", new Object[]{this.algorithm, base64Value});
    }
}

