/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.upreg.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum HashAlgorithm {
    SHA_256("SHA-256"),
    SHA_384("SHA-384"),
    SHA_512("SHA-512"),
    SHA3_256("SHA3-256"),
    SHA3_384("SHA3-384"),
    SHA3_512("SHA3-512");

    private String name;

    @JsonCreator
    public static HashAlgorithm forName(String name) {
        if (name == null) {
            return null;
        }
        for (HashAlgorithm value : HashAlgorithm.values()) {
            if (!name.equals(value.name)) continue;
            return value;
        }
        throw new IllegalArgumentException("Unknown hash algorithm name: " + name);
    }

    private HashAlgorithm(String name) {
        this.name = name;
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

