/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.upreg.client;

import de.intarsys.security.device.upreg.client.ErrorInfo;
import de.intarsys.security.device.upreg.client.Rt1GenerateRequest;
import de.intarsys.security.device.upreg.client.Rt1GenerateResponse;
import de.intarsys.security.device.upreg.client.Rt2SignRequest;
import de.intarsys.security.device.upreg.client.Rt2SignResponse;
import de.intarsys.security.device.upreg.client.StartTransactionsRequest;
import de.intarsys.security.device.upreg.client.TokenPair;
import de.intarsys.security.device.upreg.client.UPRegServiceException;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.List;

public class UPRegServiceClient {
    private WebTarget endpoint;

    public UPRegServiceClient(WebTarget endpoint) {
        this.endpoint = endpoint;
    }

    public void ping() throws UPRegServiceException {
        try (Response response = this.endpoint.path("zulab/ping").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).buildGet().invoke();){
            this.throwOnError(response);
        }
    }

    public List<TokenPair> startTransactions(int count) throws UPRegServiceException {
        StartTransactionsRequest request = new StartTransactionsRequest(count);
        try (Response response = this.endpoint.path("zulab/startTransactions").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).buildPost(Entity.json((Object)request)).invoke();){
            this.throwOnError(response);
            List tokenPairs = (List)response.readEntity((GenericType)new GenericType<List<TokenPair>>(){});
            if (tokenPairs == null) {
                throw new UPRegServiceException("Got empty service response");
            }
            if (tokenPairs.size() != count) {
                throw new UPRegServiceException(String.format("Expected %d token pairs, but got %d", count, tokenPairs.size()));
            }
            List list = tokenPairs;
            return list;
        }
    }

    public URI getAuthenticateEndpoint() {
        return this.endpoint.getUriBuilder().path("zulab/authenticate").build(new Object[0]);
    }

    public Rt1GenerateResponse rt1Generate(Rt1GenerateRequest request) throws UPRegServiceException {
        Rt1GenerateResponse response = this.post("zulab/rt1-generate", request, Rt1GenerateResponse.class);
        if (response == null) {
            throw new UPRegServiceException("Got empty service response");
        }
        return response;
    }

    public Rt2SignResponse rt2Sign(Rt2SignRequest request) throws UPRegServiceException {
        Rt2SignResponse response = this.post("zulab/rt2-sign", request, Rt2SignResponse.class);
        if (response == null) {
            throw new UPRegServiceException("Got empty response");
        }
        return response;
    }

    private <Q, R> R post(String path, Q request, Class<R> responseType) throws UPRegServiceException {
        try (Response response = this.endpoint.path(path).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).buildPost(Entity.json(request)).invoke();){
            this.throwOnError(response);
            Object object = response.readEntity(responseType);
            return (R)object;
        }
    }

    private void throwOnError(Response response) throws UPRegServiceException {
        Response.StatusType status = response.getStatusInfo();
        if (status.getFamily() == Response.Status.Family.SUCCESSFUL) {
            return;
        }
        try {
            ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
            String message = errorInfo == null ? String.format("Request failed [HTTP status %d]", status.getStatusCode()) : String.format("%d: %s [HTTP status %d]", errorInfo.getErrorCode(), errorInfo.getDescription(), status.getStatusCode());
            throw new UPRegServiceException(message, errorInfo);
        }
        catch (ProcessingException exception) {
            String message = String.format("Unknown error [HTTP status %d]", status.getStatusCode());
            throw new UPRegServiceException(message, exception);
        }
    }
}

