/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.upreg.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AuthenticateRequest {
    @JsonProperty(value="uri")
    private URI uri;
    @JsonProperty(value="auth-tokens")
    private List<String> authTokens;
    @JsonProperty(value="domain")
    private String domain;
    @JsonProperty(value="canton")
    private String canton;
    @JsonProperty(value="provider-id")
    private String providerId;
    @JsonProperty(value="provider-session-id")
    private String providerSessionId;
    @JsonProperty(value="port")
    private Integer port;

    public AuthenticateRequest(URI uri, List<String> authTokens, String domain, String canton, String providerId, String providerSessionId, Integer port) {
        this.uri = uri;
        this.authTokens = new ArrayList<String>(authTokens);
        this.domain = domain;
        this.canton = canton;
        this.providerId = providerId;
        this.providerSessionId = providerSessionId;
        this.port = port;
    }

    public URI getUri() {
        return this.uri;
    }

    public List<String> getAuthTokens() {
        return Collections.unmodifiableList(this.authTokens);
    }

    public String getDomain() {
        return this.domain;
    }

    public String getCanton() {
        return this.canton;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public String getProviderSessionId() {
        return this.providerSessionId;
    }

    public Integer getPort() {
        return this.port;
    }

    public String toString() {
        return String.format("%s(uri=%s, authTokens=%s, domain=%s, canton=%s, providerId=%s, providerSessionId=%s, port=%d)", this.getClass().getSimpleName(), this.uri, this.authTokens, this.domain, this.canton, this.providerId, this.providerSessionId, this.port);
    }
}

