/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.upreg.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.intarsys.security.app.AuthenticationFailed;
import de.intarsys.security.device.upreg.Conversations;
import de.intarsys.security.device.upreg.service.AuthenticateParameters;
import de.intarsys.security.device.upreg.service.AuthenticateRequest;
import de.intarsys.security.device.upreg.service.AuthenticateResponse;
import de.intarsys.security.device.upreg.service.ErrorInfo;
import de.intarsys.tools.conversation.ConversationExpired;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IConversationRegistry;
import de.intarsys.tools.conversation.service.impl.ConversationServiceTools;
import de.intarsys.tools.jaxrs.JaxrsTools;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="upreg")
public class SvcAuthentication {
    private static final String TEXT_ANY = "text/*";
    private static final String AUTHENTICATE_RESPONSE_PREFIX = "data=";
    private static final String DEFAULT_AUTHENTICATION_COMPLETED_PATH = "upreg/authentication-completed.html";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IConversationRegistry conversationRegistry;
    @Autowired
    private ObjectMapper objectMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="authenticationCompleted")
    @Consumes(value={"text/*"})
    public Response authenticationCompleted(@Context HttpServletRequest request, String rawResponse) {
        AuthenticateResponse response;
        this.logger.trace("SvcAuthentication.authenticationCompleted: {}", (Object)rawResponse);
        if (rawResponse == null || !rawResponse.startsWith(AUTHENTICATE_RESPONSE_PREFIX)) {
            throw new BadRequestException("Expected text/plain-encoded form with data field");
        }
        try {
            String json = rawResponse.substring(AUTHENTICATE_RESPONSE_PREFIX.length());
            response = (AuthenticateResponse)this.objectMapper.readValue(json, AuthenticateResponse.class);
        }
        catch (JsonProcessingException exception) {
            throw new BadRequestException("Expected wellformed JSON with authenticate response", (Throwable)exception);
        }
        if (response == null) {
            throw new BadRequestException("Missing authenticate response");
        }
        IConversation conversation = this.conversationRegistry.getConversation(response.getProviderSessionId());
        URI redirectUri = ConversationServiceTools.getRedirectUriExpanded((IConversation)conversation);
        if (redirectUri == null) {
            redirectUri = JaxrsTools.getUriBuilderContext((HttpServletRequest)request).path(DEFAULT_AUTHENTICATION_COMPLETED_PATH).build(new Object[0]);
        }
        try {
            conversation.complete((Object)response);
        }
        finally {
            this.conversationRegistry.unpublish(conversation);
        }
        return Response.seeOther((URI)redirectUri).build();
    }

    @POST
    @Path(value="authenticationFailed")
    public void authenticationFailed(ErrorInfo errorInfo) {
        this.logger.trace("SvcAuthentication.authenticationFailed: {}", (Object)errorInfo);
        if (errorInfo == null || errorInfo.getConversationHandle() == null) {
            throw new BadRequestException("Missing conversation parameter");
        }
        try {
            IConversation conversation = this.conversationRegistry.getConversation(errorInfo.getConversationHandle());
            String message = errorInfo.getMessage() == null ? "Authentication failed for unknown reasons" : String.format("Authentication failed: %s", errorInfo.getMessage());
            conversation.completeExceptionally((Throwable)new AuthenticationFailed(message));
            this.conversationRegistry.unpublish(conversation);
        }
        catch (ConversationExpired exception) {
            this.logger.warn("Authentication failed in expired conversation: {}", (Object)errorInfo);
        }
    }

    @POST
    @Path(value="getAuthenticateRequest")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public AuthenticateRequest getAuthenticateRequest(AuthenticateParameters parameters) {
        this.logger.trace("SvcAuthentication.getAuthenticateRequest: {}", (Object)parameters);
        if (parameters == null || parameters.getConversationHandle() == null) {
            throw new BadRequestException("Missing conversation parameter");
        }
        IConversation conversation = this.conversationRegistry.getConversation(parameters.getConversationHandle());
        AuthenticateRequest request = Conversations.getAuthenticateRequest(conversation);
        if (request == null) {
            throw new NotFoundException("No pending authentication in this conversation");
        }
        this.logger.trace("SvcAuthentication.getAuthenticateRequest: {}", (Object)request);
        return request;
    }
}

