/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.MutexHandler;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

public class DefaultMutexHandler
implements MutexHandler {
    @Override
    public Object createMutex() throws PKCS11Exception {
        return new Mutex();
    }

    @Override
    public void destroyMutex(Object mutex) throws PKCS11Exception {
    }

    @Override
    public void lockMutex(Object mutex) throws PKCS11Exception {
        try {
            Mutex castedMutex = (Mutex)mutex;
            while (true) {
                try {
                    castedMutex.lock();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (ClassCastException ex) {
            throw new PKCS11Exception(416L);
        }
    }

    @Override
    public void unlockMutex(Object mutex) throws PKCS11Exception {
        try {
            Mutex castedMutex = (Mutex)mutex;
            castedMutex.unlock();
        }
        catch (ClassCastException ex) {
            throw new PKCS11Exception(416L);
        }
    }

    class Mutex {
        protected boolean locked_ = false;

        public synchronized void lock() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            try {
                while (this.locked_) {
                    this.wait();
                }
                this.locked_ = true;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }

        public synchronized boolean unlock() {
            boolean previousState = this.locked_;
            this.locked_ = false;
            this.notify();
            return previousState;
        }

        public String toString() {
            return this.locked_ ? "locked" : "unlocked";
        }
    }
}

