/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.parameters.MessageParameters;
import iaik.pkcs.pkcs11.wrapper.CK_CCM_MESSAGE_PARAMS;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.Functions;

public class CcmMessageParameters
implements MessageParameters {
    protected long ulDataLen;
    protected byte[] pNonce;
    protected long ulNonceFixedBits;
    protected long nonceGenerator;
    protected byte[] pMAC;

    public CcmMessageParameters(long ulDataLen, byte[] pNonce, long ulNonceFixedBits, long nonceGenerator, byte[] pMAC) {
        this.ulDataLen = ulDataLen;
        this.pNonce = pNonce;
        this.ulNonceFixedBits = ulNonceFixedBits;
        this.nonceGenerator = nonceGenerator;
        this.pMAC = pMAC;
    }

    public Object clone() {
        return new CcmMessageParameters(this.ulDataLen, (byte[])this.pNonce.clone(), this.ulNonceFixedBits, this.nonceGenerator, (byte[])this.pMAC.clone());
    }

    @Override
    public Object getPKCS11ParamsObject() {
        CK_CCM_MESSAGE_PARAMS params = new CK_CCM_MESSAGE_PARAMS();
        params.ulDataLen = this.ulDataLen;
        params.pNonce = this.pNonce;
        params.ulNonceFixedBits = this.ulNonceFixedBits;
        params.nonceGenerator = this.nonceGenerator;
        params.pMAC = this.pMAC;
        return params;
    }

    @Override
    public void setValuesFromPKCS11Object(Object obj) {
        if (obj instanceof CK_CCM_MESSAGE_PARAMS) {
            this.ulDataLen = ((CK_CCM_MESSAGE_PARAMS)obj).ulDataLen;
            this.pNonce = ((CK_CCM_MESSAGE_PARAMS)obj).pNonce;
            this.ulNonceFixedBits = ((CK_CCM_MESSAGE_PARAMS)obj).ulNonceFixedBits;
            this.nonceGenerator = ((CK_CCM_MESSAGE_PARAMS)obj).nonceGenerator;
            this.pMAC = ((CK_CCM_MESSAGE_PARAMS)obj).pMAC;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Class: ");
        buffer.append(this.getClass().getName());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("ulDataLen: ");
        buffer.append(this.ulDataLen);
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("pNonce: ");
        buffer.append(Functions.toHexString(this.pNonce));
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("ulNonceFixedBits: ");
        buffer.append(this.ulNonceFixedBits);
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("pMAC: ");
        buffer.append(Functions.toHexString(this.pMAC));
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        return buffer.toString();
    }

    public boolean equals(Object otherObject) {
        boolean equal = false;
        if (otherObject instanceof CcmMessageParameters) {
            CcmMessageParameters other = (CcmMessageParameters)otherObject;
            equal = this == other || super.equals(other) && Functions.equals(this.pNonce, other.pNonce) && Functions.equals(this.pMAC, other.pMAC) && this.ulNonceFixedBits == other.ulNonceFixedBits && this.nonceGenerator == other.nonceGenerator;
        }
        return equal;
    }

    public int hashCode() {
        return super.hashCode() ^ Functions.hashCode(this.pNonce) ^ Functions.hashCode(this.pMAC) ^ new Long(this.nonceGenerator).hashCode() ^ new Long(this.ulNonceFixedBits).hashCode();
    }

    public byte[] getpMAC() {
        return this.pMAC;
    }

    public long getUlDataLen() {
        return this.ulDataLen;
    }

    public byte[] getpNonce() {
        return this.pNonce;
    }
}

