/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.parameters.MessageParameters;
import iaik.pkcs.pkcs11.parameters.Salsa20Chacha20Poly1305Parameters;
import iaik.pkcs.pkcs11.wrapper.CK_SALSA20_CHACHA20_POLY1305_MSG_PARAMS;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.Functions;

public class Salsa20Chacha20Poly1305MessageParameters
implements MessageParameters {
    protected byte[] pNonce;
    protected byte[] pTag;

    public Salsa20Chacha20Poly1305MessageParameters(byte[] pNonce, byte[] pTag) {
        this.pNonce = pNonce;
        this.pTag = pTag;
    }

    public Object clone() {
        return new Salsa20Chacha20Poly1305Parameters((byte[])this.pNonce.clone(), (byte[])this.pTag.clone());
    }

    @Override
    public Object getPKCS11ParamsObject() {
        CK_SALSA20_CHACHA20_POLY1305_MSG_PARAMS params = new CK_SALSA20_CHACHA20_POLY1305_MSG_PARAMS();
        params.pNonce = this.pNonce;
        params.pTag = this.pTag;
        return params;
    }

    @Override
    public void setValuesFromPKCS11Object(Object obj) {
        if (obj instanceof CK_SALSA20_CHACHA20_POLY1305_MSG_PARAMS) {
            this.pNonce = ((CK_SALSA20_CHACHA20_POLY1305_MSG_PARAMS)obj).pNonce;
            this.pTag = ((CK_SALSA20_CHACHA20_POLY1305_MSG_PARAMS)obj).pTag;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("pNonce: ");
        buffer.append(Functions.toHexString(this.pNonce));
        buffer.append(Constants.NEWLINE);
        buffer.append("pTag: ");
        buffer.append(Functions.toHexString(this.pTag));
        buffer.append(Constants.NEWLINE);
        return buffer.toString();
    }

    public boolean equals(Object otherObject) {
        boolean equal = false;
        if (otherObject instanceof Salsa20Chacha20Poly1305MessageParameters) {
            Salsa20Chacha20Poly1305MessageParameters other = (Salsa20Chacha20Poly1305MessageParameters)otherObject;
            equal = this == other || super.equals(other) && Functions.equals(this.pNonce, other.pNonce) && Functions.equals(this.pTag, other.pTag);
        }
        return equal;
    }

    public int hashCode() {
        return super.hashCode() ^ Functions.hashCode(this.pNonce) ^ Functions.hashCode(this.pTag);
    }
}

