/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.wrapper;

import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Implementation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class PKCS11Connector {
    private static final String WRAPPER_BASE_PATH = "natives/";
    private static final int LINUX_INDEX = 0;
    private static final int WIN_INDEX = 1;
    private static final int MAC_INDEX = 2;
    private static final int SOLARIS_INDEX = 3;
    private static final String[] WRAPPER_OS_PATH = new String[]{"unix/linux-", "windows/win-", "unix/macosx_universal/", "unix/solaris_"};
    private static final String[] WRAPPER_FILE_SUFFIX = new String[]{".so", ".dll", ".jnilib", ".so"};
    private static final String[] WRAPPER_FILE_PREFIX = new String[]{"lib", "", "lib", "lib"};
    private static final int X64_INDEX = 0;
    private static final int X86_INDEX = 1;
    private static final int SPARC_INDEX = 2;
    private static final String[] WRAPPER_ARCH_PATH = new String[]{"x86_64/", "x86/", "sparcv9/"};
    private static final String RELEASE_DIR = "release/";
    private static final String DEBUG_DIR = "debug/";

    protected PKCS11Connector() {
    }

    public static PKCS11 connectToPKCS11Module(String pkcs11ModulePath) throws IOException {
        return new PKCS11Implementation(pkcs11ModulePath);
    }

    public static PKCS11 connectToPKCS11Module(String pkcs11ModulePath, boolean wrapperDebugVersion) throws IOException {
        return new PKCS11Implementation(pkcs11ModulePath, wrapperDebugVersion);
    }

    public static PKCS11 connectToPKCS11Module(String pkcs11ModulePath, String pkcs11WrapperPath) throws IOException {
        return new PKCS11Implementation(pkcs11ModulePath, pkcs11WrapperPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void loadWrapperFromJar(boolean wrapperDebugVersion) throws IOException {
        boolean success = false;
        boolean tryAgain = false;
        int trialCounter = 0;
        String osName = System.getProperty("os.name");
        int osIndex = PKCS11Connector.getOS(osName);
        String archName = System.getProperty("os.arch");
        int archIndex = PKCS11Connector.getArch(archName);
        if (osIndex == -1) {
            osIndex = 0;
        }
        if (archIndex == -1) {
            archIndex = 0;
            ++trialCounter;
        }
        String system = WRAPPER_BASE_PATH + WRAPPER_OS_PATH[osIndex];
        String architecture = osIndex == 2 ? "" : WRAPPER_ARCH_PATH[archIndex];
        String debug = wrapperDebugVersion ? DEBUG_DIR : RELEASE_DIR;
        String libName = WRAPPER_FILE_PREFIX[osIndex] + "pkcs11wrapper";
        String osFileEnding = WRAPPER_FILE_SUFFIX[osIndex];
        do {
            tryAgain = false;
            String jarFilePath = system + architecture + debug;
            File tempWrapperFile = null;
            InputStream wrapperLibrary = PKCS11Connector.class.getClassLoader().getResourceAsStream(jarFilePath + libName + osFileEnding);
            if (wrapperLibrary == null) {
                if (trialCounter >= WRAPPER_ARCH_PATH.length) throw new IOException("No suitable wrapper native library for " + osName + " " + archName + " found in jar file.");
                archIndex = trialCounter++;
                architecture = WRAPPER_ARCH_PATH[archIndex];
                tryAgain = true;
            } else {
                try {
                    String directory = System.getProperty("PKCS11_TEMP_DIR", null);
                    if (directory != null && !directory.isEmpty()) {
                        File tempWrapperDirectory = new File(directory);
                        if (!tempWrapperDirectory.exists()) throw new IOException("Specified local temp directory '" + directory + "' does not exist!");
                        tempWrapperFile = File.createTempFile(libName, osFileEnding, tempWrapperDirectory);
                    } else {
                        tempWrapperFile = File.createTempFile(libName, osFileEnding);
                    }
                    if (!tempWrapperFile.canWrite()) {
                        throw new IOException("Can't copy wrapper native library to local temporary directory - no write permission in " + tempWrapperFile.getAbsolutePath());
                    }
                    tempWrapperFile.deleteOnExit();
                    FileOutputStream os = new FileOutputStream(tempWrapperFile);
                    try {
                        int read = 0;
                        byte[] buffer = new byte[1024];
                        while ((read = wrapperLibrary.read(buffer)) > -1) {
                            os.write(buffer, 0, read);
                        }
                    }
                    finally {
                        os.close();
                        wrapperLibrary.close();
                    }
                }
                catch (IOException e) {
                    if (tempWrapperFile != null) {
                        tempWrapperFile.delete();
                    }
                    String exceptionMessage = "Can't copy wrapper native library to local temporary directory. " + e.getMessage();
                    throw new IOException(exceptionMessage);
                }
                catch (RuntimeException e) {
                    if (tempWrapperFile == null) throw e;
                    tempWrapperFile.delete();
                    throw e;
                }
                try {
                    System.load(tempWrapperFile.getAbsolutePath());
                    return;
                }
                catch (UnsatisfiedLinkError e) {
                    tempWrapperFile.delete();
                    if (trialCounter >= WRAPPER_ARCH_PATH.length) throw new IOException("No suitable wrapper native library found in jar file. " + osName + " " + archName + " not supported.");
                    archIndex = trialCounter++;
                    architecture = WRAPPER_ARCH_PATH[archIndex];
                    tryAgain = true;
                }
            }
            if (success) return;
        } while (tryAgain);
    }

    private static int getOS(String osName) {
        if (osName.toLowerCase().indexOf("win") > -1) {
            return 1;
        }
        if (osName.toLowerCase().indexOf("linux") > -1) {
            return 0;
        }
        if (osName.toLowerCase().indexOf("mac") > -1) {
            return 2;
        }
        if (osName.toLowerCase().indexOf("sun") > -1) {
            return 3;
        }
        return -1;
    }

    private static int getArch(String jvmArch) {
        if (jvmArch.indexOf("64") > -1) {
            return 0;
        }
        if (jvmArch.indexOf("sparc") > -1) {
            return 2;
        }
        if (jvmArch.indexOf("32") > -1 || jvmArch.indexOf("86") > -1) {
            return 1;
        }
        return -1;
    }
}

