/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.wrapper;

import iaik.pkcs.pkcs11.wrapper.CK_ATTRIBUTE;
import iaik.pkcs.pkcs11.wrapper.CK_INFO;
import iaik.pkcs.pkcs11.wrapper.CK_MECHANISM;
import iaik.pkcs.pkcs11.wrapper.CK_MECHANISM_INFO;
import iaik.pkcs.pkcs11.wrapper.CK_NOTIFY;
import iaik.pkcs.pkcs11.wrapper.CK_SESSION_INFO;
import iaik.pkcs.pkcs11.wrapper.CK_SLOT_INFO;
import iaik.pkcs.pkcs11.wrapper.CK_TOKEN_INFO;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Connector;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.io.File;
import java.io.IOException;

public class PKCS11Implementation
implements PKCS11 {
    public static final String PKCS11_WRAPPER = "pkcs11wrapper";
    protected static boolean linkedAndInitialized_;
    protected String pkcs11ModulePath_;

    protected static synchronized native void initializeLibrary();

    protected static synchronized native void finalizeLibrary();

    public static synchronized void ensureLinkedAndInitialized() {
        PKCS11Implementation.ensureLinkedAndInitialized(false);
    }

    public static synchronized void ensureLinkedAndInitialized(boolean wrapperDebugVersion) {
        if (!linkedAndInitialized_) {
            try {
                System.loadLibrary(PKCS11_WRAPPER);
            }
            catch (UnsatisfiedLinkError e) {
                try {
                    PKCS11Connector.loadWrapperFromJar(wrapperDebugVersion);
                }
                catch (IOException ioe) {
                    throw new UnsatisfiedLinkError("no pkcs11wrapper in library path or jar file. " + ioe.getMessage());
                }
            }
            PKCS11Implementation.initializeLibrary();
            linkedAndInitialized_ = true;
        }
    }

    public static synchronized void ensureLinkedAndInitialized(String pkcs11WrapperPath) {
        if (!linkedAndInitialized_) {
            System.load(new File(pkcs11WrapperPath).getAbsolutePath());
            PKCS11Implementation.initializeLibrary();
            linkedAndInitialized_ = true;
        }
    }

    public static synchronized void ensureUnlinkedAndFinalized() {
        if (linkedAndInitialized_) {
            PKCS11Implementation.finalizeLibrary();
            linkedAndInitialized_ = false;
        }
    }

    PKCS11Implementation(String pkcs11ModulePath) throws IOException {
        PKCS11Implementation.ensureLinkedAndInitialized();
        this.connect(pkcs11ModulePath);
        this.pkcs11ModulePath_ = pkcs11ModulePath;
    }

    PKCS11Implementation(String pkcs11ModulePath, boolean wrapperDebugVersion) throws IOException {
        PKCS11Implementation.ensureLinkedAndInitialized(wrapperDebugVersion);
        this.connect(pkcs11ModulePath);
        this.pkcs11ModulePath_ = pkcs11ModulePath;
    }

    PKCS11Implementation(String pkcs11ModulePath, String pkcs11WrapperPath) throws IOException {
        PKCS11Implementation.ensureLinkedAndInitialized(pkcs11WrapperPath);
        this.connect(pkcs11ModulePath);
        this.pkcs11ModulePath_ = pkcs11ModulePath;
    }

    @Override
    public boolean isDisableBufferPreAllocation() {
        String disableBufferPreAllocation = System.getProperty("PKCS11_DISABLE_BUFFER_PREALLOCATION", null);
        if (disableBufferPreAllocation == null) {
            disableBufferPreAllocation = System.getenv("PKCS11_DISABLE_BUFFER_PREALLOCATION");
        }
        return disableBufferPreAllocation != null && disableBufferPreAllocation.toLowerCase().equals("true");
    }

    protected synchronized native void connect(String var1) throws IOException;

    protected synchronized native void disconnect();

    @Override
    public native void C_Initialize(Object var1, boolean var2) throws PKCS11Exception;

    @Override
    public native void C_Finalize(Object var1) throws PKCS11Exception;

    @Override
    public native CK_INFO C_GetInfo() throws PKCS11Exception;

    @Override
    public native long[] C_GetSlotList(boolean var1) throws PKCS11Exception;

    @Override
    public native CK_SLOT_INFO C_GetSlotInfo(long var1) throws PKCS11Exception;

    @Override
    public native CK_TOKEN_INFO C_GetTokenInfo(long var1) throws PKCS11Exception;

    @Override
    public native long[] C_GetMechanismList(long var1) throws PKCS11Exception;

    @Override
    public native CK_MECHANISM_INFO C_GetMechanismInfo(long var1, long var3) throws PKCS11Exception;

    @Override
    public native void C_InitToken(long var1, char[] var3, char[] var4, boolean var5) throws PKCS11Exception;

    @Override
    public native void C_InitPIN(long var1, char[] var3, boolean var4) throws PKCS11Exception;

    @Override
    public native void C_SetPIN(long var1, char[] var3, char[] var4, boolean var5) throws PKCS11Exception;

    @Override
    public native long C_OpenSession(long var1, long var3, Object var5, CK_NOTIFY var6) throws PKCS11Exception;

    @Override
    public native void C_CloseSession(long var1) throws PKCS11Exception;

    @Override
    public native void C_CloseAllSessions(long var1) throws PKCS11Exception;

    @Override
    public native CK_SESSION_INFO C_GetSessionInfo(long var1) throws PKCS11Exception;

    @Override
    public native void C_SessionCancel(long var1, long var3) throws PKCS11Exception;

    @Override
    public native byte[] C_GetOperationState(long var1) throws PKCS11Exception;

    @Override
    public native void C_SetOperationState(long var1, byte[] var3, long var4, long var6) throws PKCS11Exception;

    @Override
    public native void C_Login(long var1, long var3, char[] var5, boolean var6) throws PKCS11Exception;

    @Override
    public native void C_LoginUser(long var1, long var3, char[] var5, char[] var6, boolean var7) throws PKCS11Exception;

    @Override
    public native void C_Logout(long var1) throws PKCS11Exception;

    @Override
    public native long C_CreateObject(long var1, CK_ATTRIBUTE[] var3, boolean var4) throws PKCS11Exception;

    @Override
    public native long C_CopyObject(long var1, long var3, CK_ATTRIBUTE[] var5, boolean var6) throws PKCS11Exception;

    @Override
    public native void C_DestroyObject(long var1, long var3) throws PKCS11Exception;

    @Override
    public native long C_GetObjectSize(long var1, long var3) throws PKCS11Exception;

    @Override
    public native void C_GetAttributeValue(long var1, long var3, CK_ATTRIBUTE[] var5, boolean var6) throws PKCS11Exception;

    @Override
    public native void C_SetAttributeValue(long var1, long var3, CK_ATTRIBUTE[] var5, boolean var6) throws PKCS11Exception;

    @Override
    public native void C_FindObjectsInit(long var1, CK_ATTRIBUTE[] var3, boolean var4) throws PKCS11Exception;

    @Override
    public native long[] C_FindObjects(long var1, long var3) throws PKCS11Exception;

    @Override
    public native void C_FindObjectsFinal(long var1) throws PKCS11Exception;

    @Override
    public native void C_EncryptInit(long var1, CK_MECHANISM var3, long var4, boolean var6) throws PKCS11Exception;

    @Override
    public native byte[] C_Encrypt(long var1, byte[] var3) throws PKCS11Exception;

    @Override
    public native byte[] C_EncryptUpdate(long var1, byte[] var3) throws PKCS11Exception;

    @Override
    public native byte[] C_EncryptFinal(long var1) throws PKCS11Exception;

    @Override
    public native void C_MessageEncryptInit(long var1, CK_MECHANISM var3, long var4, boolean var6) throws PKCS11Exception;

    @Override
    public native byte[] C_EncryptMessage(long var1, Object var3, byte[] var4, byte[] var5, boolean var6) throws PKCS11Exception;

    @Override
    public native void C_EncryptMessageBegin(long var1, Object var3, byte[] var4, boolean var5) throws PKCS11Exception;

    @Override
    public native byte[] C_EncryptMessageNext(long var1, Object var3, byte[] var4, long var5, boolean var7) throws PKCS11Exception;

    @Override
    public native void C_MessageEncryptFinal(long var1) throws PKCS11Exception;

    @Override
    public native void C_DecryptInit(long var1, CK_MECHANISM var3, long var4, boolean var6) throws PKCS11Exception;

    @Override
    public native byte[] C_Decrypt(long var1, byte[] var3) throws PKCS11Exception;

    @Override
    public native byte[] C_DecryptUpdate(long var1, byte[] var3) throws PKCS11Exception;

    @Override
    public native byte[] C_DecryptFinal(long var1) throws PKCS11Exception;

    @Override
    public native void C_MessageDecryptInit(long var1, CK_MECHANISM var3, long var4, boolean var6) throws PKCS11Exception;

    @Override
    public native byte[] C_DecryptMessage(long var1, Object var3, byte[] var4, byte[] var5, boolean var6) throws PKCS11Exception;

    @Override
    public native void C_DecryptMessageBegin(long var1, Object var3, byte[] var4, boolean var5) throws PKCS11Exception;

    @Override
    public native byte[] C_DecryptMessageNext(long var1, Object var3, byte[] var4, long var5, boolean var7) throws PKCS11Exception;

    @Override
    public native void C_MessageDecryptFinal(long var1) throws PKCS11Exception;

    @Override
    public native void C_DigestInit(long var1, CK_MECHANISM var3, boolean var4) throws PKCS11Exception;

    @Override
    public native byte[] C_Digest(long var1, byte[] var3) throws PKCS11Exception;

    @Override
    public native void C_DigestUpdate(long var1, byte[] var3) throws PKCS11Exception;

    @Override
    public native void C_DigestKey(long var1, long var3) throws PKCS11Exception;

    @Override
    public native byte[] C_DigestFinal(long var1) throws PKCS11Exception;

    @Override
    public native void C_SignInit(long var1, CK_MECHANISM var3, long var4, boolean var6) throws PKCS11Exception;

    @Override
    public native byte[] C_Sign(long var1, byte[] var3) throws PKCS11Exception;

    @Override
    public native void C_SignUpdate(long var1, byte[] var3) throws PKCS11Exception;

    @Override
    public native byte[] C_SignFinal(long var1) throws PKCS11Exception;

    @Override
    public native void C_SignRecoverInit(long var1, CK_MECHANISM var3, long var4, boolean var6) throws PKCS11Exception;

    @Override
    public native byte[] C_SignRecover(long var1, byte[] var3) throws PKCS11Exception;

    @Override
    public native void C_MessageSignInit(long var1, CK_MECHANISM var3, long var4, boolean var6);

    @Override
    public native byte[] C_SignMessage(long var1, Object var3, byte[] var4, boolean var5);

    @Override
    public native void C_SignMessageBegin(long var1, Object var3, boolean var4);

    @Override
    public native byte[] C_SignMessageNext(long var1, Object var3, byte[] var4, boolean var5, boolean var6);

    @Override
    public native void C_MessageSignFinal(long var1);

    @Override
    public native void C_VerifyInit(long var1, CK_MECHANISM var3, long var4, boolean var6) throws PKCS11Exception;

    @Override
    public native void C_Verify(long var1, byte[] var3, byte[] var4) throws PKCS11Exception;

    @Override
    public native void C_VerifyUpdate(long var1, byte[] var3) throws PKCS11Exception;

    @Override
    public native void C_VerifyFinal(long var1, byte[] var3) throws PKCS11Exception;

    @Override
    public native void C_VerifyRecoverInit(long var1, CK_MECHANISM var3, long var4, boolean var6) throws PKCS11Exception;

    @Override
    public native byte[] C_VerifyRecover(long var1, byte[] var3) throws PKCS11Exception;

    @Override
    public native void C_MessageVerifyInit(long var1, CK_MECHANISM var3, long var4, boolean var6) throws PKCS11Exception;

    @Override
    public native void C_VerifyMessage(long var1, Object var3, byte[] var4, byte[] var5, boolean var6) throws PKCS11Exception;

    @Override
    public native void C_VerifyMessageBegin(long var1, Object var3, boolean var4) throws PKCS11Exception;

    @Override
    public native void C_VerifyMessageNext(long var1, Object var3, byte[] var4, byte[] var5, boolean var6) throws PKCS11Exception;

    @Override
    public native void C_MessageVerifyFinal(long var1) throws PKCS11Exception;

    @Override
    public native byte[] C_DigestEncryptUpdate(long var1, byte[] var3) throws PKCS11Exception;

    @Override
    public native byte[] C_DecryptDigestUpdate(long var1, byte[] var3) throws PKCS11Exception;

    @Override
    public native byte[] C_SignEncryptUpdate(long var1, byte[] var3) throws PKCS11Exception;

    @Override
    public native byte[] C_DecryptVerifyUpdate(long var1, byte[] var3) throws PKCS11Exception;

    @Override
    public native long C_GenerateKey(long var1, CK_MECHANISM var3, CK_ATTRIBUTE[] var4, boolean var5) throws PKCS11Exception;

    @Override
    public native long[] C_GenerateKeyPair(long var1, CK_MECHANISM var3, CK_ATTRIBUTE[] var4, CK_ATTRIBUTE[] var5, boolean var6) throws PKCS11Exception;

    @Override
    public native byte[] C_WrapKey(long var1, CK_MECHANISM var3, long var4, long var6, boolean var8) throws PKCS11Exception;

    @Override
    public native long C_UnwrapKey(long var1, CK_MECHANISM var3, long var4, byte[] var6, CK_ATTRIBUTE[] var7, boolean var8) throws PKCS11Exception;

    @Override
    public native long C_DeriveKey(long var1, CK_MECHANISM var3, long var4, CK_ATTRIBUTE[] var6, boolean var7) throws PKCS11Exception;

    @Override
    public native void C_SeedRandom(long var1, byte[] var3) throws PKCS11Exception;

    @Override
    public native void C_GenerateRandom(long var1, byte[] var3) throws PKCS11Exception;

    @Override
    public native void C_GetFunctionStatus(long var1) throws PKCS11Exception;

    @Override
    public native void C_CancelFunction(long var1) throws PKCS11Exception;

    @Override
    public native long C_WaitForSlotEvent(long var1, Object var3) throws PKCS11Exception;

    public boolean equals(Object otherObject) {
        boolean equal;
        block9: {
            if (this == otherObject) {
                equal = true;
            } else if (otherObject instanceof PKCS11Implementation) {
                PKCS11Implementation other = (PKCS11Implementation)otherObject;
                if (this.pkcs11ModulePath_.equals(other.pkcs11ModulePath_)) {
                    equal = true;
                } else {
                    try {
                        File thisLibarayFile = new File(this.pkcs11ModulePath_);
                        File otherLibaryFile = new File(other.pkcs11ModulePath_);
                        if (thisLibarayFile.getCanonicalPath().equals(otherLibaryFile.getCanonicalPath())) {
                            equal = true;
                            break block9;
                        }
                        equal = false;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        equal = false;
                    }
                }
            } else {
                equal = false;
            }
        }
        return equal;
    }

    public int hashCode() {
        int hashCode;
        try {
            File thisLibarayFile = new File(this.pkcs11ModulePath_);
            hashCode = thisLibarayFile.getCanonicalPath().hashCode();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            hashCode = this.pkcs11ModulePath_.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Module Name: ");
        buffer.append(this.pkcs11ModulePath_);
        return buffer.toString();
    }

    @Override
    public void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }
}

