/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.annotation.widget;

import de.intarsys.pdf.app.annotation.common.CommonAnnotationFactory;
import de.intarsys.pdf.app.annotation.widget.WidgetFactory;
import de.intarsys.pdf.app.design.AnnotationDesignerException;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.design.tools.FormTools;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontTools;
import de.intarsys.pdf.pd.PDAcroForm;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAppearanceCharacteristics;
import de.intarsys.pdf.pd.PDBorderStyle;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDResources;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.awt.Color;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WidgetSubFactory
extends CommonAnnotationFactory {
    public static final String ARG_BACKGROUND_BGCOLOR = "backgroundColor";
    public static final String ARG_BACKGROUND_BORDERCOLOR = "borderColor";
    public static final String ARG_BACKGROUND_BORDERWIDTH = "borderWidth";
    public static final String ATTR_BACKGROUND = "background";
    public static final String ATTR_ROTATE = "rotate";
    public static final String ATTR_TEXTCOLOR = "textColor";
    private static final byte[] defaultAppearanceString = "/Helv 0 Tf 0 g".getBytes();
    private static final COSName fontName = COSName.constant((String)"Helv");
    private static final Logger Log = LoggerFactory.getLogger(WidgetSubFactory.class);

    @Override
    protected PDAnnotation basicCreateAnnotation(PDPage page, CDSRectangle rect, Map attributes) {
        PDWidgetAnnotation annot = (PDWidgetAnnotation)PDWidgetAnnotation.META.createNew();
        annot.cosGetDict().put(PDAcroFormField.DK_FT, this.getFieldType().copyShallow());
        return annot;
    }

    protected void checkDefaultResources(PDAcroForm form) {
        COSObject cosFont;
        PDResources resources = form.getDefaultResources();
        if (resources == null) {
            resources = (PDResources)PDResources.META.createNew();
            form.setDefaultResources(resources);
        }
        if ((cosFont = resources.cosGetResource(PDResources.CN_RT_Font, fontName)).isNull()) {
            PDFont font = PDFontTools.getFont((PDDocument)form.getDoc(), (PDResources)resources, (COSName)COSName.create((String)"Helvetica"));
            resources.addFontResource(fontName, font);
        }
    }

    @Override
    protected void createAnnotationReference(PDPage page, PDAnnotation annotation, Map attributes) throws ObjectCreationException {
        super.createAnnotationReference(page, annotation, attributes);
        try {
            PDAcroForm form = FormTools.createAcroForm(page.getDoc());
            this.checkDefaultResources(form);
            PDWidgetAnnotation widget = (PDWidgetAnnotation)annotation;
            PDAcroFormField field = widget.getAcroFormField();
            String fieldName = this.createFieldName(form, attributes);
            FormTools.addField(field, fieldName, form);
        }
        catch (AnnotationDesignerException e) {
            throw new ObjectCreationException((Throwable)e);
        }
    }

    @Override
    protected void createAnnotationState(PDPage page, PDAnnotation annotation, CDSRectangle rect, Map attributes) throws ObjectCreationException {
        Args annotationStateArgs;
        super.createAnnotationState(page, annotation, rect, attributes);
        PDWidgetAnnotation widget = (PDWidgetAnnotation)annotation;
        widget.setBorderStyle((PDBorderStyle)PDBorderStyle.META.createNew());
        PDAppearanceCharacteristics appearance = PDAppearanceCharacteristics.META.createNew();
        widget.setAppearanceCharacteristics(appearance);
        widget.setPrint(true);
        int rotation = 0;
        rotation += page.getNormalizedRotate();
        Object attrRotate = attributes.get(ATTR_ROTATE);
        if (attrRotate != null) {
            rotation = (rotation + Integer.valueOf((String)attrRotate)) % 360;
        }
        if (rotation != 0) {
            appearance.setRotation(rotation);
        }
        try {
            annotationStateArgs = ArgTools.toArgs(attributes.get(ATTR_BACKGROUND));
            if (annotationStateArgs == null) {
                annotationStateArgs = Args.create();
            }
        }
        catch (ClassCastException ex) {
            annotationStateArgs = Args.create();
        }
        float borderWidth = ArgTools.getFloat((IArgs)annotationStateArgs, (String)ARG_BACKGROUND_BORDERWIDTH, (float)this.getDefaultBorderWidth());
        annotation.setBorderStyleWidth(borderWidth);
        Color borderColor = ArgTools.getColor((IArgs)annotationStateArgs, (String)ARG_BACKGROUND_BORDERCOLOR, null);
        appearance.setBorderColor(borderColor == null ? this.getDefaultBorderColor() : borderColor.getRGBColorComponents(null));
        Color backgroundColor = ArgTools.getColor((IArgs)annotationStateArgs, (String)ARG_BACKGROUND_BGCOLOR, null);
        appearance.setBackgroundColor(backgroundColor == null ? this.getDefaultFillColor() : backgroundColor.getRGBColorComponents(null));
        this.createWidgetAnnotationState(page, widget, rect, attributes);
    }

    protected void createDefaultAppearance(PDAcroFormField field, Map attributes) {
        CSContent appearance = CSContent.createFromBytes((byte[])defaultAppearanceString);
        field.setDefaultAppearanceContent(appearance);
        String textColorString = (String)attributes.get(ATTR_TEXTCOLOR);
        try {
            Color textColor = (Color)ConverterRegistry.get().convert((Object)textColorString, Color.class);
            if (textColor != null) {
                field.setDefaultAppearanceFontColor(textColor.getRGBColorComponents(null));
            }
        }
        catch (ConversionException ex) {
            Log.warn(ex.getMessage(), (Throwable)ex);
        }
    }

    protected String createFieldName(PDAcroForm form, Map attributes) {
        Object fieldName = WidgetFactory.getFieldName(attributes);
        if (fieldName == null) {
            String basename = this.getNamePrefix();
            int i = 1;
            while (form.getField(basename + i) != null) {
                ++i;
            }
            fieldName = basename + i;
        }
        return fieldName;
    }

    protected void createWidgetAnnotationState(PDPage page, PDWidgetAnnotation widget, CDSRectangle rect, Map attributes) {
        this.createDefaultAppearance(widget.getAcroFormField(), attributes);
    }

    public COSName getAnnotationType() {
        return null;
    }

    protected float[] getDefaultBorderColor() {
        return null;
    }

    protected float getDefaultBorderWidth() {
        return 0.0f;
    }

    protected float[] getDefaultFillColor() {
        return null;
    }

    protected abstract COSName getFieldType();

    protected abstract String getNamePrefix();
}

