/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.page;

import de.intarsys.pdf.app.page.PageSelector;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.tools.number.NumberParser;
import de.intarsys.tools.number.NumberWrapper;
import de.intarsys.tools.range.IRangeContext;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MultiPageSelector
extends PageSelector {
    public static final String VALUE_PAGERANGE_ALL = "all";
    public static final String DEFAULT_PAGERANGE = "all";
    public static final String VALUE_PAGERANGE_CURRENT = "current";
    public static final String VALUE_PAGERANGE_CUSTOM = "custom";
    public static final String VALUE_PAGERANGE_FIRST = "first";
    public static final String VALUE_PAGERANGE_LAST = "last";
    private String pageRange = "all";
    private IRangeContext rangeContext;

    public MultiPageSelector() {
    }

    public MultiPageSelector(String pageRange, IRangeContext pageContext) {
        this.setPageRange(pageRange);
        this.setRangeContext(pageContext);
    }

    @Override
    public String asString() {
        return this.pageRange;
    }

    protected List<PDPage> createList(PDDocument doc) {
        ArrayList<PDPage> pages = new ArrayList<PDPage>();
        if (StringTools.isNumeric((String)this.pageRange)) {
            int pageCount = doc.getPageTree().getCount();
            try {
                NumberWrapper wrapper = NumberParser.parseInteger((String)this.pageRange.trim());
                for (Number number : wrapper) {
                    PDPage page;
                    int index = number.intValue();
                    if (index < 0 || index >= pageCount || (page = doc.getPageTree().getPageAt(index)) == null) continue;
                    pages.add(page);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return pages;
        }
        if (this.pageRange.equals("all")) {
            for (PDPage page = doc.getPageTree().getFirstPage(); page != null; page = page.getNextPage()) {
                pages.add(page);
            }
            return pages;
        }
        if (this.pageRange.equals(VALUE_PAGERANGE_FIRST)) {
            PDPage page = doc.getPageTree().getFirstPage();
            if (page != null) {
                pages.add(page);
            }
            return pages;
        }
        if (this.pageRange.equals(VALUE_PAGERANGE_LAST)) {
            PDPage page = doc.getPageTree().getLastPage();
            if (page != null) {
                pages.add(page);
            }
            return pages;
        }
        if (this.pageRange.equals(VALUE_PAGERANGE_CURRENT)) {
            if (this.getRangeContext() == null) {
                PDPage page = doc.getPageTree().getFirstPage();
                if (page != null) {
                    pages.add(page);
                }
                return pages;
            }
            PDPage page = doc.getPageTree().getPageAt(this.getRangeContext().getCurrent());
            if (page == null) {
                page = doc.getPageTree().getFirstPage();
            }
            if (page != null) {
                pages.add(page);
            }
            return pages;
        }
        for (PDPage page = doc.getPageTree().getFirstPage(); page != null; page = page.getNextPage()) {
            pages.add(page);
        }
        return pages;
    }

    public String getPageRange() {
        return this.pageRange;
    }

    @Override
    public Iterator<PDPage> getPages(PDDocument doc) {
        return this.createList(doc).iterator();
    }

    public IRangeContext getRangeContext() {
        return this.rangeContext;
    }

    public void setPageRange(String pageRange) {
        if (StringTools.isEmpty((String)pageRange)) {
            pageRange = "all";
        }
        this.pageRange = pageRange;
    }

    public void setRangeContext(IRangeContext pageContext) {
        this.rangeContext = pageContext;
    }
}

