/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.widget;

import de.intarsys.pdf.app.annotation.AnnotationOutlet;
import de.intarsys.pdf.app.annotation.IAnnotationFactory;
import de.intarsys.pdf.app.appearance.AppearanceCreatorTools;
import de.intarsys.pdf.app.appearance.IAppearanceCreator;
import de.intarsys.pdf.app.appearance.ITextFormatProvider;
import de.intarsys.pdf.app.appearance.common.FontInfo;
import de.intarsys.pdf.app.page.PageSelector;
import de.intarsys.pdf.app.page.PageTools;
import de.intarsys.pdf.app.page.StaticSinglePageSelector;
import de.intarsys.pdf.design.shape.Group;
import de.intarsys.pdf.design.shape.ShapeAppearanceCreator;
import de.intarsys.pdf.design.widget.AnnotationApplication;
import de.intarsys.pdf.design.widget.AnnotationType;
import de.intarsys.pdf.design.widget.IFieldDefinition;
import de.intarsys.pdf.design.widget.PlainApplication;
import de.intarsys.pdf.pd.AcroFormFieldFlags;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDMarkupAnnotation;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import de.intarsys.pdf.tools.kernel.PDFColorTools;
import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.enumeration.common.EnumAlignment;
import de.intarsys.tools.enumeration.common.EnumDistanceUnit;
import de.intarsys.tools.enumeration.common.EnumResize;
import de.intarsys.tools.enumeration.common.EnumUnit;
import de.intarsys.tools.enumeration.common.IAlignment;
import de.intarsys.tools.enumeration.common.IResize;
import de.intarsys.tools.enumeration.common.RectAlignment;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.Map;

public class AnnotationDefinition {
    private static final String ARG_SHAPES = "shapes";
    private final IFieldDefinition fieldDefinition;
    private final IArgs args;
    private boolean adjustForRotate = true;
    private EnumAlignment hAlign = EnumAlignment.START;
    private EnumAlignment vAlign = EnumAlignment.START;
    private Point2D positionScaled;
    private Point2D sizeScaled;
    private AnnotationType annotationType = AnnotationType.auto;
    private AnnotationApplication annotationApplication = new PlainApplication();
    private EnumDistanceUnit distanceUnit = EnumDistanceUnit.POINT;
    private PageSelector pageSelector;
    private ITextFormatProvider textFormatProvider;
    private FontInfo fontInfo = new FontInfo();
    private EnumResize hResize;
    private EnumResize vResize;

    public AnnotationDefinition(IFieldDefinition fieldDefinition, IArgs args) {
        this.fieldDefinition = fieldDefinition;
        this.args = args;
        this.initFromArgs();
    }

    protected PDAnnotation createAnnotation(IAnnotationFactory factory, PDPage page, String fieldName) throws ObjectCreationException {
        ArgTools.expandDeep((IArgs)this.getArgs(), (IStringEvaluator)this.getFieldDefinition().getTemplateEvaluator());
        Map attributes = ArgTools.toMap((IArgs)this.getArgs());
        Rectangle2D rect = this.getAnnotationApplication().createRect(this, page);
        if (this.isWidget()) {
            attributes.put("fieldName", fieldName);
            if ("Sig".equals(this.getFieldDefinition().getFieldType())) {
                attributes.put(PDAcroFormField.DK_FT, PDAcroFormField.CN_FT_Sig);
                AcroFormFieldFlags flags = new AcroFormFieldFlags(0);
                attributes.put(PDAcroFormField.DK_Ff, flags);
                return factory.createAnnotation(page, rect, attributes);
            }
            if ("Tx".equals(this.getFieldDefinition().getFieldType())) {
                attributes.put(PDAcroFormField.DK_FT, PDAcroFormField.CN_FT_Tx);
                AcroFormFieldFlags flags = new AcroFormFieldFlags(0);
                flags.setEdit(true);
                attributes.put(PDAcroFormField.DK_Ff, flags);
                return factory.createAnnotation(page, rect, attributes);
            }
        } else {
            return factory.createAnnotation(page, rect, attributes);
        }
        throw new IllegalArgumentException("field type '" + this.getFieldDefinition().getFieldType() + "' not supported");
    }

    protected IAnnotationFactory createAnnotationFactory() {
        if (this.isWidget()) {
            return AnnotationOutlet.get().lookupAnnotationFactory(PDWidgetAnnotation.CN_Subtype_Widget);
        }
        return AnnotationOutlet.get().lookupAnnotationFactory(PDMarkupAnnotation.CN_Subtype_Ink);
    }

    public PDAnnotation createAnnotations(String currentFieldName) throws ObjectCreationException {
        String tmpFieldName = StringTools.isEmpty((String)currentFieldName) ? this.getAnnotationApplication().createFieldName(this) : currentFieldName;
        IAppearanceCreator appearanceCreator = this.createAppearanceCreator();
        IAnnotationFactory factory = this.createAnnotationFactory();
        PageSelector tempSelector = this.getPageSelector();
        if (tempSelector == null) {
            tempSelector = new StaticSinglePageSelector(0);
        }
        Iterator<PDPage> it = tempSelector.getPages(this.getDocument());
        PDAnnotation result = null;
        while (it.hasNext()) {
            PDPage page = it.next();
            result = this.createAnnotation(factory, page, tmpFieldName);
            if (!this.isWidget()) {
                result.getFlags().setLocked(true);
                result.getFlags().setLockedContents(true);
                result.getFlags().setReadOnly(true);
            }
            if (result instanceof PDWidgetAnnotation) {
                PDWidgetAnnotation wa = (PDWidgetAnnotation)result;
                PDAcroFormField field = wa.getAcroFormField();
                if (StringTools.isEmpty((String)tmpFieldName)) {
                    tmpFieldName = field.getLocalName();
                }
                this.getFontInfo().initField(field);
            }
            AppearanceCreatorTools.setTextFormatProvider((PDAnnotation)result, (ITextFormatProvider)this.getTextFormatProvider());
            AppearanceCreatorTools.createAppearance((PDAnnotation)result, (IAppearanceCreator)appearanceCreator);
        }
        return result;
    }

    protected IAppearanceCreator createAppearanceCreator() {
        IArgs argsShapes = ArgTools.getArgs((IArgs)this.getArgs(), (String)ARG_SHAPES, null);
        if (argsShapes != null) {
            return this.createAppearanceCreatorFromShapes();
        }
        if (this.getFieldDefinition() != null) {
            return this.getFieldDefinition().getAppearanceCreator();
        }
        return null;
    }

    protected IAppearanceCreator createAppearanceCreatorFromShapes() {
        ShapeAppearanceCreator creator = new ShapeAppearanceCreator();
        creator.setShape(this.createShape());
        if (this.getFieldDefinition() != null) {
            creator.setEmbedFonts(this.getFieldDefinition().isEmbedFonts());
        }
        return creator;
    }

    public String createFieldName() {
        return this.getAnnotationApplication().createFieldName(this);
    }

    public Rectangle2D createRect() {
        return this.getAnnotationApplication().createRect(this);
    }

    public Group createShape() {
        ArgTools.expandDeep((IArgs)this.getArgs(), (IStringEvaluator)this.getTemplateEvaluator());
        Group group = Group.create((IArgs)this.getArgs());
        RectAlignment alignment = new RectAlignment();
        EnumResize tmpResize = this.getHResize() == null ? EnumResize.FILL : this.getHResize();
        alignment.setHorizontalResize((IResize)tmpResize);
        tmpResize = this.getVResize() == null ? tmpResize : this.getVResize();
        alignment.setVerticalResize((IResize)tmpResize);
        group.setAlignment(alignment);
        return group;
    }

    public AnnotationApplication getAnnotationApplication() {
        return this.annotationApplication;
    }

    public AnnotationType getAnnotationType() {
        return this.annotationType;
    }

    public IArgs getArgs() {
        return this.args;
    }

    public String getContents() {
        return ArgTools.getString((IArgs)this.getArgs(), (String)"contents", null);
    }

    public EnumDistanceUnit getDistanceUnit() {
        return this.distanceUnit;
    }

    public PDDocument getDocument() {
        if (this.getFieldDefinition() == null) {
            return null;
        }
        return this.getFieldDefinition().getDocument();
    }

    public IFieldDefinition getFieldDefinition() {
        return this.fieldDefinition;
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }

    public EnumAlignment getHAlign() {
        return this.hAlign;
    }

    public EnumResize getHResize() {
        return this.hResize;
    }

    public PageSelector getPageSelector() {
        return this.pageSelector;
    }

    public Point2D getPosition() {
        if (this.positionScaled != null) {
            if (EnumDistanceUnit.POINT == this.getDistanceUnit()) {
                return this.positionScaled;
            }
            double tmpX = this.getDistanceUnit().convertTo((EnumUnit)EnumDistanceUnit.POINT, this.positionScaled.getX());
            double tmpY = this.getDistanceUnit().convertTo((EnumUnit)EnumDistanceUnit.POINT, this.positionScaled.getY());
            return new Point2D.Double(tmpX, tmpY);
        }
        return null;
    }

    public Point2D getPositionScaled() {
        return this.positionScaled;
    }

    public Point2D getSize() {
        if (this.sizeScaled != null) {
            if (EnumDistanceUnit.POINT == this.getDistanceUnit()) {
                return this.sizeScaled;
            }
            double tmpX = this.getDistanceUnit().convertTo((EnumUnit)EnumDistanceUnit.POINT, this.sizeScaled.getX());
            double tmpY = this.getDistanceUnit().convertTo((EnumUnit)EnumDistanceUnit.POINT, this.sizeScaled.getY());
            return new Point2D.Double(tmpX, tmpY);
        }
        return null;
    }

    public Point2D getSizeScaled() {
        return this.sizeScaled;
    }

    public String getSubject() {
        return ArgTools.getString((IArgs)this.getArgs(), (String)"subject", null);
    }

    public IStringEvaluator getTemplateEvaluator() {
        if (this.getFieldDefinition() == null) {
            return null;
        }
        return this.getFieldDefinition().getTemplateEvaluator();
    }

    public ITextFormatProvider getTextFormatProvider() {
        return this.textFormatProvider;
    }

    public String getTitle() {
        return ArgTools.getString((IArgs)this.getArgs(), (String)"title", null);
    }

    public EnumAlignment getVAlign() {
        return this.vAlign;
    }

    public EnumResize getVResize() {
        return this.vResize;
    }

    protected void initFromArgs() {
        IArgs applyArgs;
        AnnotationDefinition defaultDef = null;
        if (this.isWidget()) {
            defaultDef = this.getFieldDefinition().getDefaultAnnotationDefinition();
        }
        if (defaultDef == null) {
            defaultDef = this;
        }
        this.setAnnotationApplication((applyArgs = ArgTools.getArgs((IArgs)this.getArgs(), (String)"apply", null)) == null ? defaultDef.getAnnotationApplication() : AnnotationApplication.createFromArgs(applyArgs));
        this.setAdjustForRotate(ArgTools.getBoolStrict((IArgs)this.getArgs(), (String)"adjustForRotate", (boolean)defaultDef.isAdjustForRotate()));
        EnumDistanceUnit tmpDistanceUnit = (EnumDistanceUnit)ArgTools.getEnumItemStrict((IArgs)this.getArgs(), (EnumMeta)EnumDistanceUnit.META, (String)"unit", (EnumItem)defaultDef.getDistanceUnit());
        this.setDistanceUnit(tmpDistanceUnit);
        this.setPositionScaled(ArgTools.getPointStrict((IArgs)this.getArgs(), (String)"position", (String)"x", (String)"y", (Point2D)defaultDef.getPositionScaled()));
        this.setSizeScaled(ArgTools.getPointStrict((IArgs)this.getArgs(), (String)"size", (String)"width", (String)"height", (Point2D)defaultDef.getSizeScaled()));
        PageSelector tmpPageSelector = PageTools.getPageSelector(this.getArgs(), null);
        if (tmpPageSelector == null) {
            tmpPageSelector = defaultDef.getPageSelector();
        }
        this.setPageSelector(tmpPageSelector);
        this.setAnnotationType((AnnotationType)ArgTools.getEnumStrict((IArgs)this.getArgs(), AnnotationType.class, (String)"annotationType", (Enum)defaultDef.getAnnotationType()));
        this.getFontInfo().setFontFactory(defaultDef.getFontInfo().getFontFactory());
        this.getFontInfo().setFontName(defaultDef.getFontInfo().getFontName());
        this.getFontInfo().setFontSize(defaultDef.getFontInfo().getFontSize());
        this.getFontInfo().setFontColor(defaultDef.getFontInfo().getFontColor());
        IArgs fontArgs = ArgTools.getArgs((IArgs)this.args, (String)"font", null);
        if (fontArgs != null) {
            String fontColor;
            String fontSize;
            String fontName;
            String fontStyle;
            String fontFamilyName = ArgTools.getString((IArgs)fontArgs, (String)"fontFamilyName", null);
            if (fontFamilyName != null) {
                this.getFontInfo().setFontFamilyName(fontFamilyName);
            }
            if ((fontStyle = ArgTools.getString((IArgs)fontArgs, (String)"fontStyle", null)) != null) {
                this.getFontInfo().setFontStyle(fontStyle);
            }
            if ((fontName = ArgTools.getString((IArgs)fontArgs, (String)"fontName", null)) != null) {
                this.getFontInfo().setFontName(fontName);
            }
            if ((fontSize = ArgTools.getString((IArgs)fontArgs, (String)"fontSize", null)) != null) {
                this.getFontInfo().setFontSize(Float.parseFloat(fontSize));
            }
            if ((fontColor = ArgTools.getString((IArgs)fontArgs, (String)"fontColor", null)) != null) {
                this.getFontInfo().setFontColor(PDFColorTools.parse((String)fontColor));
            }
        }
        EnumAlignment fieldHalign = EnumAlignment.createFromArgs((IArgs)this.getArgs(), (String)"hAlign", (IAlignment)defaultDef.getHAlign());
        this.setHAlign(fieldHalign);
        EnumAlignment fieldValign = EnumAlignment.createFromArgs((IArgs)this.getArgs(), (String)"vAlign", (IAlignment)defaultDef.getVAlign());
        this.setVAlign(fieldValign);
        this.setHResize((EnumResize)ArgTools.getEnumItemStrict((IArgs)this.getArgs(), (EnumMeta)EnumResize.META, (String)"hResize", (EnumItem)defaultDef.getHResize()));
        this.setVResize((EnumResize)ArgTools.getEnumItemStrict((IArgs)this.getArgs(), (EnumMeta)EnumResize.META, (String)"vResize", (EnumItem)defaultDef.getVResize()));
        this.setTitle(ArgTools.getString((IArgs)this.getArgs(), (String)"title", (String)defaultDef.getTitle()));
        this.setSubject(ArgTools.getString((IArgs)this.getArgs(), (String)"subject", (String)defaultDef.getSubject()));
        this.setContents(ArgTools.getString((IArgs)this.getArgs(), (String)"contents", (String)defaultDef.getContents()));
    }

    public boolean isAdjustForRotate() {
        return this.adjustForRotate;
    }

    public boolean isWidget() {
        return this.getFieldDefinition() != null && this.getAnnotationType() != AnnotationType.markup;
    }

    public void setAdjustForRotate(boolean adjustForRotate) {
        this.adjustForRotate = adjustForRotate;
    }

    public void setAnnotationApplication(AnnotationApplication annotationApplication) {
        this.annotationApplication = annotationApplication;
    }

    public void setAnnotationType(AnnotationType annotationType) {
        this.annotationType = annotationType;
    }

    public void setContents(String contents) {
        this.getArgs().put("contents", (Object)contents);
    }

    public void setDistanceUnit(EnumDistanceUnit distanceUnit) {
        this.distanceUnit = distanceUnit;
    }

    public void setFontInfo(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
    }

    public void setHAlign(EnumAlignment hAlign) {
        this.hAlign = hAlign;
    }

    public void setHResize(EnumResize hResize) {
        this.hResize = hResize;
    }

    public void setPageSelector(PageSelector pageSelector) {
        this.pageSelector = pageSelector;
    }

    public void setPositionScaled(Point2D positionScaled) {
        this.positionScaled = positionScaled;
    }

    public void setSizeScaled(Point2D sizeScaled) {
        this.sizeScaled = sizeScaled;
    }

    public void setSubject(String subject) {
        this.getArgs().put("subject", (Object)subject);
    }

    public void setTextFormatProvider(ITextFormatProvider textFormatProvider) {
        this.textFormatProvider = textFormatProvider;
    }

    public void setTitle(String title) {
        this.getArgs().put("title", (Object)title);
    }

    public void setVAlign(EnumAlignment vAlign) {
        this.vAlign = vAlign;
    }

    public void setVResize(EnumResize vResize) {
        this.vResize = vResize;
    }
}

