/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.widget;

import de.intarsys.pdf.design.shape.Shape;
import de.intarsys.pdf.design.shape.ShapeFactories;
import de.intarsys.pdf.design.widget.AnnotationDefinition;
import de.intarsys.pdf.design.widget.CommonFieldDefinitionStrategy;
import de.intarsys.pdf.design.widget.IFieldDefinition;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.form.model.CommonField;
import de.intarsys.tools.form.model.FieldValue;
import de.intarsys.tools.form.model.Form;
import de.intarsys.tools.form.model.FormValue;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ArgsDefinitionStrategy
extends CommonFieldDefinitionStrategy {
    protected void createAnnotationDefinitionsFromAnnotations(IFieldDefinition fieldDefinition, List<AnnotationDefinition> annotationDefinitions) {
        IArgs argAnnotations = ArgTools.getArgs((IArgs)fieldDefinition.getFieldArgs(), (String)"annotations", null);
        if (argAnnotations == null) {
            return;
        }
        for (IArgs.IBinding binding : argAnnotations) {
            IArgs annotationArgs = ArgTools.toArgs((Object)binding.getValue()).copy();
            AnnotationDefinition annotDef = this.createAnnotationDefinition(fieldDefinition, annotationArgs);
            annotationDefinitions.add(annotDef);
        }
    }

    protected void createAnnotationDefinitionsFromForm(IFieldDefinition fieldDefinition, List<AnnotationDefinition> annotationDefinitions) {
        IArgs argFormValue = ArgTools.getArgs((IArgs)fieldDefinition.getFieldArgs(), (String)"formValue", null);
        FormValue formValue = FormValue.createFromArgs((IArgs)argFormValue);
        if (formValue == null) {
            return;
        }
        try {
            formValue.expandValues(fieldDefinition.getTemplateEvaluator());
        }
        catch (EvaluationException e) {
            throw new IllegalArgumentException("invalid form value (" + e.getMessage() + ")", e);
        }
        for (FieldValue fieldValue : formValue.getValues()) {
            IArgs annotationArgs = this.createArgsAnnotation(fieldValue);
            AnnotationDefinition annotDef = this.createAnnotationDefinition(fieldDefinition, annotationArgs);
            annotationDefinitions.add(annotDef);
        }
    }

    protected IArgs createArgsAnnotation(FieldValue fieldValue) {
        CommonField field = fieldValue.getField();
        Form form = field.getForm();
        Args annotationArgs = Args.create();
        annotationArgs.put("adjustForRotate", (Object)true);
        annotationArgs.put("x", (Object)Float.valueOf(field.getX()));
        annotationArgs.put("y", (Object)Float.valueOf(field.getY()));
        annotationArgs.put("width", (Object)Float.valueOf(field.getWidth()));
        annotationArgs.put("height", (Object)Float.valueOf(field.getHeight()));
        annotationArgs.put("pageRange", (Object)field.getPageRange());
        annotationArgs.put("hResize", (Object)field.getHResize());
        annotationArgs.put("vResize", (Object)field.getVResize());
        annotationArgs.put("annotationType", field.getProperty("annotationType", form.getProperty("annotationType", null)));
        Shape shape = this.createShape(fieldValue);
        if (shape != null) {
            annotationArgs.put("shapes", (Object)ListTools.with((Object[])new Shape[]{shape}));
        } else {
            annotationArgs.put("shapes", Collections.emptyList());
        }
        return annotationArgs;
    }

    @Override
    public PDAcroFormField createField(PDDocument doc, IFieldDefinition fieldDefinition) {
        if (doc == null) {
            return null;
        }
        if (this.detectAcroFormField(doc, fieldDefinition) != null) {
            throw new IllegalArgumentException("field '" + fieldDefinition.getFieldName() + "' already present");
        }
        ArrayList<AnnotationDefinition> annotationDefinitions = new ArrayList<AnnotationDefinition>();
        this.createAnnotationDefinitionsFromAnnotations(fieldDefinition, annotationDefinitions);
        this.createAnnotationDefinitionsFromForm(fieldDefinition, annotationDefinitions);
        if (annotationDefinitions.isEmpty()) {
            AnnotationDefinition annotDef = fieldDefinition.getDefaultAnnotationDefinition();
            annotationDefinitions.add(annotDef);
        }
        this.createAnnotationDefinitionsFromEndorsement(fieldDefinition, annotationDefinitions);
        return this.createField(doc, fieldDefinition, annotationDefinitions);
    }

    protected Shape createShape(FieldValue fieldValue) {
        return ShapeFactories.createShape((FieldValue)fieldValue);
    }
}

