/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.widget.format;

import de.intarsys.pdf.app.acroform.FormHandlerFactory;
import de.intarsys.pdf.app.acroform.IFormHandler;
import de.intarsys.pdf.design.tools.FormTools;
import de.intarsys.pdf.design.widget.format.CommonScriptBasedObject;
import de.intarsys.pdf.design.widget.format.CustomCalculationRule;
import de.intarsys.pdf.design.widget.format.DateCalculationRule;
import de.intarsys.pdf.design.widget.format.FunctionParser;
import de.intarsys.pdf.design.widget.format.IScriptBasedObject;
import de.intarsys.pdf.design.widget.format.JSFieldTools;
import de.intarsys.pdf.design.widget.format.NullCalculationRule;
import de.intarsys.pdf.design.widget.format.SimpleCalculationRule;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAdditionalActions;
import java.util.Collections;

public abstract class FieldCalculationRule
extends CommonScriptBasedObject {
    public static final String[] TYPES = new String[]{"none", "simple", "date", "custom"};
    protected static final FieldCalculationRule NULLRULE = new NullCalculationRule();
    private String calculationScript = "";

    public static FieldCalculationRule createFromField(PDAcroFormField field) {
        String calculationScript = JSFieldTools.getJavaScript(field, PDAdditionalActions.CN_trigger_C);
        FieldCalculationRule rule = NULLRULE;
        if (calculationScript != null) {
            rule = FunctionParser.parseCalculationRule(calculationScript);
            rule.setCalculationScript(calculationScript);
        }
        return rule;
    }

    public static FieldCalculationRule createNew(String type) {
        if ("none".equals(type)) {
            return new NullCalculationRule();
        }
        if ("simple".equals(type)) {
            return new SimpleCalculationRule();
        }
        if ("date".equals(type)) {
            return new DateCalculationRule();
        }
        if ("custom".equals(type)) {
            return new CustomCalculationRule();
        }
        return null;
    }

    protected FieldCalculationRule() {
    }

    @Override
    protected void basicCommit(PDAcroFormField field) {
        IFormHandler formHandler;
        boolean wasCalculated = false;
        PDAdditionalActions actions = field.getAdditionalActions();
        if (actions != null && actions.getAction(PDAdditionalActions.CN_trigger_C) != null) {
            wasCalculated = true;
        }
        JSFieldTools.setJavaScript(field, PDAdditionalActions.CN_trigger_C, this.getCalculationScript());
        if (wasCalculated) {
            if (this.getCalculationScript() == null) {
                FormTools.calculationOrderRemove(field.getAcroForm(), field);
            }
        } else if (this.getCalculationScript() != null) {
            FormTools.calculationOrderAdd(field.getAcroForm(), field);
        }
        if ((formHandler = FormHandlerFactory.get().createFormHandler(field.getDoc(), Collections.emptyMap())) != null) {
            formHandler.recalculate();
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FieldCalculationRule)) {
            return false;
        }
        FieldCalculationRule rule = (FieldCalculationRule)obj;
        if (!this.getType().equals(rule.getType())) {
            return false;
        }
        return !(this.getCalculationScript() == null ? rule.getCalculationScript() != null : !this.getCalculationScript().equals(rule.getCalculationScript()));
    }

    public String getCalculationScript() {
        return this.calculationScript;
    }

    @Override
    protected IScriptBasedObject parseObject(PDAcroFormField field) {
        return FieldCalculationRule.createFromField(field);
    }

    public void setCalculationScript(String calculationScript) {
        this.calculationScript = calculationScript;
    }
}

