/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.widget.format;

import de.intarsys.pdf.design.widget.format.CommonScriptBasedObject;
import de.intarsys.pdf.design.widget.format.CustomValidationRule;
import de.intarsys.pdf.design.widget.format.FunctionParser;
import de.intarsys.pdf.design.widget.format.IScriptBasedObject;
import de.intarsys.pdf.design.widget.format.JSFieldTools;
import de.intarsys.pdf.design.widget.format.NullValidationRule;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAdditionalActions;

public abstract class FieldValidationRule
extends CommonScriptBasedObject {
    public static final String[] TYPES = new String[]{"none", "custom"};
    protected static final FieldValidationRule NULLRULE = new NullValidationRule();
    private String validationScript = "";

    public static FieldValidationRule createFromField(PDAcroFormField field) {
        String calculationScript = JSFieldTools.getJavaScript(field, PDAdditionalActions.CN_trigger_V);
        FieldValidationRule rule = NULLRULE;
        if (calculationScript != null) {
            rule = FunctionParser.parseValidationRule(calculationScript);
            rule.setValidationScript(calculationScript);
        }
        return rule;
    }

    public static FieldValidationRule createNew(String type) {
        if ("none".equals(type)) {
            return new NullValidationRule();
        }
        if ("custom".equals(type)) {
            return new CustomValidationRule();
        }
        return null;
    }

    protected FieldValidationRule() {
    }

    @Override
    protected void basicCommit(PDAcroFormField field) {
        JSFieldTools.setJavaScript(field, PDAdditionalActions.CN_trigger_V, this.getValidationScript());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FieldValidationRule)) {
            return false;
        }
        FieldValidationRule rule = (FieldValidationRule)obj;
        if (!this.getType().equals(rule.getType())) {
            return false;
        }
        return !(this.getValidationScript() == null ? rule.getValidationScript() != null : !this.getValidationScript().equals(rule.getValidationScript()));
    }

    public String getValidationScript() {
        return this.validationScript;
    }

    @Override
    protected IScriptBasedObject parseObject(PDAcroFormField field) {
        return FieldValidationRule.createFromField(field);
    }

    public void setValidationScript(String calculationScript) {
        this.validationScript = calculationScript;
    }
}

