/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.widget.format;

import de.intarsys.pdf.design.widget.format.FieldFormat;
import java.util.Arrays;
import java.util.List;

public abstract class NumericFormat
extends FieldFormat {
    public String[] SEPARATOR_PATTERNS = new String[]{"CommaDot", "Dot", "DotComma", "Comma", "ApostropheComma", "ApostropheDot"};
    private int decimals = 2;
    private int separator = 2;

    protected NumericFormat() {
    }

    protected NumericFormat(int decimals, int separator) {
        this.setDecimals(decimals);
        this.setSeparator(separator);
    }

    public int getDecimals() {
        return this.decimals;
    }

    public int getSeparator() {
        return this.separator;
    }

    private int getSeparatorIndex(String pattern) {
        for (int i = 0; i < this.SEPARATOR_PATTERNS.length; ++i) {
            if (!this.SEPARATOR_PATTERNS[i].equals(pattern)) continue;
            return i;
        }
        return -1;
    }

    public String getSeparatorLabel(String pattern) {
        int index = this.getSeparatorIndex(pattern);
        switch (index) {
            case 0: {
                return "1,234.56";
            }
            case 1: {
                return "1234.56";
            }
            case 2: {
                return "1.234,56";
            }
            case 3: {
                return "1234,56";
            }
            case 4: {
                return "1'234,56";
            }
            case 5: {
                return "1'234.56";
            }
        }
        return pattern;
    }

    public String getSeparatorPattern() {
        return this.SEPARATOR_PATTERNS[this.getSeparator()];
    }

    public List getSeparatorPatterns() {
        return Arrays.asList(this.SEPARATOR_PATTERNS);
    }

    public void setDecimals(int decimals) {
        this.decimals = decimals;
    }

    public void setSeparator(int separator) {
        this.separator = separator;
    }

    public void setSeparatorPattern(String pattern) {
        this.separator = this.getSeparatorIndex(pattern);
    }
}

