/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.form.model;

import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.form.model.CommonField;
import de.intarsys.tools.form.model.Form;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;

public class FieldValue {
    private CommonField field;
    private Object value;

    public static FieldValue createFrom(CommonField field, Object fieldValue) {
        if (field == null) {
            return null;
        }
        FieldValue value = new FieldValue();
        value.setField(field);
        Object restoredValue = field.restore(fieldValue);
        value.setValue(restoredValue);
        return value;
    }

    public static FieldValue createFrom(Form form, IArgs.IBinding binding) {
        String fieldName = binding.getName();
        Object fieldValue = binding.getValue();
        return FieldValue.createFrom(form, fieldName, fieldValue);
    }

    public static FieldValue createFrom(Form form, String fieldName, Object fieldValue) {
        CommonField field = form.getField(fieldName);
        return FieldValue.createFrom(field, fieldValue);
    }

    public static FieldValue createFromArgs(IArgs args) {
        if (args == null || args.size() == 0) {
            return null;
        }
        IArgs fieldArgs = ArgTools.getArgs((IArgs)args, (String)"field", (IArgs)Args.create());
        Form form = new Form();
        CommonField field = CommonField.createFromArgs(ArgTools.toArgs((Object)fieldArgs));
        form.addField(field);
        Object fieldValue = ArgTools.getObject((IArgs)args, (String)"value", null);
        return FieldValue.createFrom(field, fieldValue);
    }

    public void expand(IStringEvaluator templateEvaluator) throws EvaluationException {
        if (this.value == null) {
            return;
        }
        if (this.value instanceof String) {
            this.value = templateEvaluator.evaluate((String)this.value, (IArgs)Args.create());
        }
        if (this.value instanceof IArgs) {
            ArgTools.expandDeep((IArgs)((IArgs)this.value), (IStringEvaluator)templateEvaluator);
        }
    }

    public CommonField getField() {
        return this.field;
    }

    public String getFormattedValue() {
        return this.getField().format(this.value);
    }

    public Object getValue() {
        return this.value;
    }

    public void setField(CommonField field) {
        this.field = field;
    }

    public void setValue(Object value) {
        this.value = value;
    }
}

