/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.form.model;

import de.intarsys.tools.form.model.CommonField;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import java.util.ArrayList;
import java.util.List;

public class Form {
    private String id;
    private List<CommonField> fields = new ArrayList<CommonField>();
    private IArgs properties;

    public static Form createFromArgs(IArgs args) {
        if (args == null || args.size() == 0) {
            return null;
        }
        Form form = new Form();
        form.setId(ArgTools.getString((IArgs)args, (String)"id", null));
        IArgs fieldArgs = ArgTools.getArgs((IArgs)args, (String)"fields", (IArgs)Args.create());
        for (IArgs.IBinding binding : fieldArgs) {
            CommonField field = CommonField.createFromArgs(ArgTools.toArgs((Object)binding.getValue()));
            form.addField(field);
        }
        IArgs propertyArgs = ArgTools.getArgs((IArgs)args, (String)"properties", (IArgs)Args.create());
        form.setProperties(propertyArgs);
        return form;
    }

    public void addField(CommonField field) {
        this.fields.add(field);
        field.setForm(this);
    }

    public CommonField getField(String name) {
        return this.fields.stream().filter(field -> field.getId().equals(name)).findAny().orElse(null);
    }

    public List<CommonField> getFields() {
        return this.fields;
    }

    public String getId() {
        return this.id;
    }

    public IArgs getProperties() {
        return this.properties;
    }

    public Object getProperty(String name, Object defaultValue) {
        return ArgTools.getObject((IArgs)this.properties, (String)name, (Object)defaultValue);
    }

    public void removeField(CommonField field) {
        this.fields.remove(field);
        field.setForm(null);
    }

    public void setFields(List<CommonField> fields) {
        this.fields = fields;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setProperties(IArgs args) {
        this.properties = args;
    }

    public void setProperty(String name, Object value) {
        ArgTools.putPath((IArgs)this.properties, (String)name, (Object)value);
    }
}

