/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.swagger.v3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.swagger.v3.IOpenApiVisitor;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.tags.Tag;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public abstract class CommonOpenApiVisitor
implements IOpenApiVisitor {
    private static final Object NULL = new Object();
    private OpenAPI openApi;
    private Deque<String> contextStackPath = new ArrayDeque<String>();
    private Deque<String> contextStackSegment = new ArrayDeque<String>();
    private Deque<Object> contextStackModel = new ArrayDeque<Object>();
    private Set<String> loadedModels = new HashSet<String>();
    private Map<Object, Object> visited = new IdentityHashMap<Object, Object>();

    public final Object acceptContent(Content content) {
        return this.visitedIfAbsent(content, value -> this.basicAcceptContent((Content)value));
    }

    public final Object acceptExample(Example example) {
        return this.visitedIfAbsent(example, value -> this.basicAcceptExample((Example)value));
    }

    @Override
    public final Object acceptInfo(Info info) {
        return this.visitedIfAbsent(info, value -> this.basicAcceptInfo((Info)value));
    }

    public final Object acceptMediaType(MediaType mediaType) {
        return this.visitedIfAbsent(mediaType, value -> this.basicAcceptMediaType((MediaType)value));
    }

    @Override
    public Object acceptOpenApi(OpenAPI openApi) {
        this.openApi = openApi;
        this.contextStackModel.clear();
        this.contextStackPath.clear();
        this.contextStackSegment.clear();
        this.contextStackPath.push("/");
        this.contextPush("OpenAPI", openApi);
        this.doOpenApiInfo();
        this.doOpenApiPaths();
        this.doOpenApiTags();
        this.doOpenApiComponents();
        return null;
    }

    @Override
    public final Object acceptOperation(Operation operation) {
        return this.visitedIfAbsent(operation, value -> this.basicAcceptOperation((Operation)value));
    }

    @Override
    public final Object acceptParameter(Parameter parameter) {
        return this.visitedIfAbsent(parameter, value -> this.basicAcceptParameter((Parameter)value));
    }

    @Override
    public final Object acceptPathItem(PathItem pathItem) {
        return this.visitedIfAbsent(pathItem, value -> this.basicAcceptPathItem((PathItem)value));
    }

    public final Object acceptRequest(RequestBody body) {
        return this.visitedIfAbsent(body, value -> this.basicAcceptRequest((RequestBody)value));
    }

    @Override
    public final Object acceptResponse(ApiResponse response) {
        return this.visitedIfAbsent(response, value -> this.basicAcceptResponse((ApiResponse)value));
    }

    public final Object acceptResponses(ApiResponses responses) {
        return this.visitedIfAbsent(responses, value -> this.basicAcceptResponses((ApiResponses)value));
    }

    @Override
    public final Object acceptSchema(Schema<Object> schema) {
        return this.visitedIfAbsent(schema, value -> this.basicAcceptSchema((Schema<Object>)value));
    }

    @Override
    public final Object acceptTag(Tag tag) {
        return this.visitedIfAbsent(tag, value -> this.basicAcceptTag((Tag)value));
    }

    protected Object basicAcceptContent(Content content) {
        for (Map.Entry entry : content.entrySet()) {
            this.acceptMediaType((MediaType)entry.getValue());
        }
        return null;
    }

    protected Object basicAcceptExample(Example value) {
        return null;
    }

    protected Object basicAcceptInfo(Info value) {
        return null;
    }

    protected Object basicAcceptMediaType(MediaType mediaType) {
        if (mediaType.getSchema() != null) {
            this.acceptSchema((Schema<Object>)mediaType.getSchema());
        }
        if (mediaType.getExamples() != null) {
            for (Map.Entry entry : mediaType.getExamples().entrySet()) {
                this.acceptExample((Example)entry.getValue());
            }
        }
        return null;
    }

    protected Object basicAcceptOperation(Operation operation) {
        if (operation.getRequestBody() != null) {
            this.acceptRequest(operation.getRequestBody());
        }
        if (operation.getResponses() != null) {
            this.acceptResponses(operation.getResponses());
        }
        return null;
    }

    protected Object basicAcceptParameter(Parameter value) {
        return null;
    }

    protected Object basicAcceptPathItem(PathItem pathItem) {
        for (Map.Entry entry : pathItem.readOperationsMap().entrySet()) {
            this.acceptOperation((Operation)entry.getValue());
        }
        return null;
    }

    protected Object basicAcceptRequest(RequestBody value) {
        this.acceptContent(value.getContent());
        return null;
    }

    protected Object basicAcceptResponse(ApiResponse value) {
        return null;
    }

    protected Object basicAcceptResponses(ApiResponses responses) {
        for (ApiResponse response : responses.values()) {
            this.acceptResponse(response);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object basicAcceptSchema(Schema<Object> schema) {
        ArraySchema array;
        if (schema.getProperties() != null) {
            HashMap properties = new HashMap(schema.getProperties());
            for (Map.Entry entry : properties.entrySet()) {
                try {
                    this.contextPush((String)entry.getKey(), schema);
                    this.acceptSchema((Schema<Object>)((Schema)entry.getValue()));
                }
                finally {
                    this.contextPop();
                }
            }
        }
        if (schema.getNot() != null) {
            try {
                this.contextPush("not", schema);
                this.acceptSchema((Schema<Object>)schema.getNot());
            }
            finally {
                this.contextPop();
            }
        }
        if (schema.getAdditionalProperties() instanceof Schema) {
            try {
                this.contextPush("additional", schema);
                this.acceptSchema((Schema<Object>)((Schema)schema.getAdditionalProperties()));
            }
            finally {
                this.contextPop();
            }
        }
        if (schema instanceof ComposedSchema) {
            ComposedSchema composed = (ComposedSchema)schema;
            if (composed.getAllOf() != null) {
                try {
                    this.contextPush("allOf", schema);
                    for (Schema childSchema : composed.getAllOf()) {
                        this.acceptSchema((Schema<Object>)childSchema);
                    }
                }
                finally {
                    this.contextPop();
                }
            }
            if (composed.getAnyOf() != null) {
                try {
                    this.contextPush("anyOf", schema);
                    for (Schema childSchema : composed.getAnyOf()) {
                        this.acceptSchema((Schema<Object>)childSchema);
                    }
                }
                finally {
                    this.contextPop();
                }
            }
            if (composed.getOneOf() != null) {
                try {
                    this.contextPush("oneOf", schema);
                    for (Schema childSchema : composed.getOneOf()) {
                        this.acceptSchema((Schema<Object>)childSchema);
                    }
                }
                finally {
                    this.contextPop();
                }
            }
        }
        if (schema instanceof ArraySchema && (array = (ArraySchema)schema).getItems() != null) {
            try {
                this.contextPush("items", schema);
                this.acceptSchema((Schema<Object>)array.getItems());
            }
            finally {
                this.contextPop();
            }
        }
        return null;
    }

    protected Object basicAcceptTag(Tag value) {
        return null;
    }

    protected Object contextPeekModel() {
        return this.contextStackModel.peek();
    }

    protected String contextPeekPath() {
        return this.contextStackPath.peek();
    }

    protected String contextPeekSegment() {
        return this.contextStackSegment.peek();
    }

    protected void contextPop() {
        this.contextStackSegment.pop();
        this.contextStackModel.pop();
        this.contextStackPath.pop();
    }

    protected void contextPush(String segment, Object model) {
        this.contextStackSegment.push(segment);
        this.contextStackModel.push(model == null ? NULL : model);
        this.contextStackPath.push(PathTools.join((String[])new String[]{this.contextStackPath.peek(), segment}));
    }

    protected void doOpenApiComponents() {
        Components components = this.openApi.getComponents();
        if (components != null) {
            this.contextPush("components", components);
            try {
                this.doOpenApiComponentsSchemas(components);
                this.doOpenApiComponentsExamples(components);
                this.doOpenApiComponentsRequestBodies(components);
                this.doOpenApiComponentsResponses(components);
            }
            finally {
                this.contextPop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOpenApiComponentsExamples(Components components) {
        if (components.getExamples() != null) {
            HashMap examples = new HashMap(components.getExamples());
            try {
                this.contextPush("examples", examples);
                for (Map.Entry entry : examples.entrySet()) {
                    this.acceptExample((Example)entry.getValue());
                }
            }
            finally {
                this.contextPop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOpenApiComponentsRequestBodies(Components components) {
        if (components.getRequestBodies() != null) {
            HashMap requestBodies = new HashMap(components.getRequestBodies());
            try {
                this.contextPush("requestBodies", requestBodies);
                for (Map.Entry entry : requestBodies.entrySet()) {
                    this.acceptRequest((RequestBody)entry.getValue());
                }
            }
            finally {
                this.contextPop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOpenApiComponentsResponses(Components components) {
        if (components.getResponses() != null) {
            HashMap responses = new HashMap(components.getResponses());
            try {
                this.contextPush("responses", responses);
                for (Map.Entry entry : responses.entrySet()) {
                    try {
                        this.contextPush((String)entry.getKey(), entry.getValue());
                        this.acceptResponse((ApiResponse)entry.getValue());
                    }
                    finally {
                        this.contextPop();
                    }
                }
            }
            finally {
                this.contextPop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOpenApiComponentsSchemas(Components components) {
        if (components.getSchemas() != null) {
            HashMap schemas = new HashMap(components.getSchemas());
            try {
                this.contextPush("schemas", schemas);
                for (Map.Entry entry : schemas.entrySet()) {
                    try {
                        this.contextPush((String)entry.getKey(), entry.getValue());
                        this.acceptSchema((Schema<Object>)((Schema)entry.getValue()));
                    }
                    finally {
                        this.contextPop();
                    }
                }
            }
            finally {
                this.contextPop();
            }
        }
    }

    protected void doOpenApiInfo() {
        try {
            this.contextPush("info", this.openApi.getInfo());
            this.acceptInfo(this.openApi.getInfo());
        }
        finally {
            this.contextPop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOpenApiPaths() {
        Paths paths = this.openApi.getPaths();
        if (paths != null) {
            try {
                this.contextPush("paths", paths);
                for (Map.Entry entry : paths.entrySet()) {
                    try {
                        this.contextPush((String)entry.getKey(), entry.getValue());
                        this.acceptPathItem((PathItem)entry.getValue());
                    }
                    finally {
                        this.contextPop();
                    }
                }
            }
            finally {
                this.contextPop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOpenApiTags() {
        if (this.openApi.getTags() != null) {
            ArrayList tags = new ArrayList(this.openApi.getTags());
            try {
                this.contextPush("tags", tags);
                for (Tag tag : tags) {
                    try {
                        this.contextPush(tag.getName(), tag);
                        this.acceptTag(tag);
                    }
                    finally {
                        this.contextPop();
                    }
                }
            }
            finally {
                this.contextPop();
            }
        }
    }

    protected ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    protected ObjectMapper getObjectMapper() {
        return Json.mapper();
    }

    public OpenAPI getOpenApi() {
        return this.openApi;
    }

    protected boolean isEscape(Object description) {
        return description instanceof String && ((String)description).startsWith("@");
    }

    protected Object loadBasic(String resource) throws IOException {
        resource = PathTools.withoutLeadingSeparator((String)resource);
        try (InputStream is = this.getClassLoader().getResourceAsStream(resource);){
            if (is == null) {
                throw new FileNotFoundException();
            }
            if (resource.endsWith(".json")) {
                Object object = this.getObjectMapper().readValue(is, JsonNode.class);
                return object;
            }
            if (resource.endsWith(".md")) {
                String string = StreamTools.getString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                return string;
            }
            throw new IOException("<resource " + resource + " not supported>");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T loadModel(String resource, Class<T> clazz) {
        if (!this.loadedModels.add(resource)) {
            return null;
        }
        resource = PathTools.withoutLeadingSeparator((String)resource);
        resource = PathTools.join((String[])new String[]{resource, "object.json"});
        try (InputStream is = this.getClassLoader().getResourceAsStream(resource);){
            Object object = is == null ? null : Json.mapper().readValue(is, clazz);
            return (T)object;
        }
        catch (Exception e) {
            throw ExceptionTools.wrap((Throwable)e);
        }
    }

    protected Object loadObject(String resource) {
        try {
            return this.loadBasic(resource);
        }
        catch (Exception e) {
            try {
                String absolute = PathTools.join((String[])new String[]{this.contextPeekPath(), resource});
                return this.loadBasic(absolute);
            }
            catch (Exception inner) {
                return null;
            }
        }
    }

    protected String loadString(String resource) {
        return (String)this.loadObject(resource);
    }

    public void setOpenApi(OpenAPI openApi) {
        this.openApi = openApi;
    }

    protected <M, R> R visitedIfAbsent(M model, Function<M, R> accept) {
        if (this.visited.containsKey(model)) {
            return (R)this.visited.get(model);
        }
        this.visited.put(model, null);
        R result = accept.apply(model);
        this.visited.put(model, result);
        return result;
    }
}

