/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.swagger.v3;

import de.intarsys.tools.component.IOrdered;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.swagger.v3.CommonOpenApiVisitor;
import io.swagger.v3.jaxrs2.ReaderListener;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.integration.api.OpenApiReader;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.tags.Tag;

@OpenAPIDefinition
public class OpenAPICollector
extends CommonOpenApiVisitor
implements ReaderListener,
IOrdered {
    public void afterScan(OpenApiReader reader, OpenAPI openAPI) {
        this.acceptOpenApi(openAPI);
    }

    @Override
    protected Object basicAcceptInfo(Info info) {
        info = this.ensureLoadedInfo(info);
        return super.basicAcceptInfo(info);
    }

    @Override
    protected Object basicAcceptOperation(Operation operation) {
        if (operation.getTags() != null) {
            for (String tag : operation.getTags()) {
                this.ensureLoadedTag(tag, null);
            }
        }
        return super.basicAcceptOperation(operation);
    }

    @Override
    protected Object basicAcceptPathItem(PathItem pathItem) {
        pathItem = this.ensureLoadedPathItem(this.contextPeekSegment(), pathItem);
        return super.basicAcceptPathItem(pathItem);
    }

    @Override
    protected Object basicAcceptResponse(ApiResponse response) {
        String ref = response.get$ref();
        ApiResponse refModel = this.ensureLoadedResponse(ref, response);
        this.acceptResponse(refModel);
        return super.basicAcceptResponse(response);
    }

    @Override
    protected Object basicAcceptSchema(Schema<Object> schema) {
        schema = this.ensureLoadedSchema(schema.getName(), schema);
        String ref = schema.get$ref();
        Schema refModel = this.ensureLoadedSchema(ref, null);
        this.acceptSchema((Schema<Object>)refModel);
        return super.basicAcceptSchema((Schema<Object>)schema);
    }

    @Override
    protected Object basicAcceptTag(Tag tag) {
        tag = this.ensureLoadedTag(tag.getName(), tag);
        return super.basicAcceptTag(tag);
    }

    public void beforeScan(OpenApiReader reader, OpenAPI openAPI) {
    }

    protected Example ensureLoadedExample(String name, Example defaultValue) {
        if (!StringTools.isEmpty((String)name)) {
            String loadedName = PathTools.getName((String)name);
            String resourceName = PathTools.join((String[])new String[]{"/OpenAPI/components/examples", loadedName});
            Example loaded = this.loadModel(resourceName, Example.class);
            if (loaded != null) {
                this.getOpenApi().getComponents().addExamples(loadedName, loaded);
                return loaded;
            }
        }
        return defaultValue;
    }

    protected Info ensureLoadedInfo(Info defaultValue) {
        String resourceName = "/OpenAPI/info";
        Info loaded = this.loadModel(resourceName, Info.class);
        if (loaded != null) {
            this.getOpenApi().info(loaded);
            return loaded;
        }
        return defaultValue;
    }

    protected PathItem ensureLoadedPathItem(String name, PathItem defaultValue) {
        if (!StringTools.isEmpty((String)name)) {
            String loadedName = name;
            String resourceName = PathTools.join((String[])new String[]{"/OpenAPI/paths", loadedName});
            PathItem loaded = this.loadModel(resourceName, PathItem.class);
            if (loaded != null) {
                this.getOpenApi().path(loadedName, loaded);
                return loaded;
            }
        }
        return defaultValue;
    }

    protected ApiResponse ensureLoadedResponse(String name, ApiResponse defaultValue) {
        if (!StringTools.isEmpty((String)name)) {
            String loadedName = PathTools.getName((String)name);
            String resourceName = PathTools.join((String[])new String[]{"/OpenAPI/components/responses", loadedName});
            ApiResponse loaded = this.loadModel(resourceName, ApiResponse.class);
            if (loaded != null) {
                this.getOpenApi().getComponents().addResponses(loadedName, loaded);
                return loaded;
            }
        }
        return defaultValue;
    }

    protected Schema ensureLoadedSchema(String name, Schema defaultValue) {
        if (!StringTools.isEmpty((String)name)) {
            String loadedName = PathTools.getName((String)name);
            String resourceName = PathTools.join((String[])new String[]{"/OpenAPI/components/schemas", loadedName});
            Schema loaded = this.loadModel(resourceName, Schema.class);
            if (loaded != null) {
                loaded.setName(loadedName);
                this.getOpenApi().schema(loadedName, loaded);
                return loaded;
            }
        }
        return defaultValue;
    }

    protected Tag ensureLoadedTag(String name, Tag defaultValue) {
        String resource;
        Tag loaded;
        if (!StringTools.isEmpty((String)name) && (loaded = this.loadModel(resource = PathTools.join((String[])new String[]{"/OpenAPI/tags", name}), Tag.class)) != null) {
            this.getOpenApi().addTagsItem(loaded);
            return loaded;
        }
        return defaultValue;
    }

    public int getOrder() {
        return 10;
    }
}

