/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.swagger.v3;

import de.intarsys.tools.component.IOrdered;
import io.swagger.v3.jaxrs2.Reader;
import io.swagger.v3.jaxrs2.ReaderListener;
import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.integration.api.OpenApiReader;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderOrderedListener
extends Reader {
    private static final Logger Log = LoggerFactory.getLogger(ReaderOrderedListener.class);

    public ReaderOrderedListener() {
    }

    public ReaderOrderedListener(OpenAPI openAPI) {
        super(openAPI);
    }

    public ReaderOrderedListener(OpenAPIConfiguration openApiConfiguration) {
        super(openApiConfiguration);
    }

    public OpenAPI read(Set<Class<?>> classes) {
        TreeSet sortedClasses = new TreeSet((class1, class2) -> {
            if (class1.equals(class2)) {
                return 0;
            }
            if (class1.isAssignableFrom((Class<?>)class2)) {
                return -1;
            }
            if (class2.isAssignableFrom((Class<?>)class1)) {
                return 1;
            }
            return class1.getName().compareTo(class2.getName());
        });
        sortedClasses.addAll(classes);
        ArrayList<ReaderListener> listeners = new ArrayList<ReaderListener>();
        for (Class clazz : sortedClasses) {
            if (!ReaderListener.class.isAssignableFrom(clazz)) continue;
            try {
                listeners.add((ReaderListener)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                Log.error("Failed to create ReaderListener", (Throwable)e);
            }
        }
        listeners.sort((l1, l2) -> {
            int order1 = 0;
            int order2 = 0;
            if (l1 instanceof IOrdered) {
                order1 = ((IOrdered)l1).getOrder();
            }
            if (l2 instanceof IOrdered) {
                order2 = ((IOrdered)l2).getOrder();
            }
            return order1 - order2;
        });
        for (ReaderListener readerListener : listeners) {
            try {
                readerListener.beforeScan((OpenApiReader)this, this.getOpenAPI());
            }
            catch (Exception e) {
                Log.error("Unexpected error invoking beforeScan listener [" + readerListener.getClass().getName() + "]", (Throwable)e);
            }
        }
        for (Class clazz : sortedClasses) {
            this.read(clazz, this.resolveApplicationPath(), null, false, null, null, new LinkedHashSet(), new ArrayList(), new HashSet());
        }
        for (ReaderListener readerListener : listeners) {
            try {
                readerListener.afterScan((OpenApiReader)this, this.getOpenAPI());
            }
            catch (Exception e) {
                Log.error("Unexpected error invoking afterScan listener [" + readerListener.getClass().getName() + "]", (Throwable)e);
            }
        }
        return this.getOpenAPI();
    }
}

