/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.observation.api;

import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.valueholder.INamedValue;
import de.intarsys.tools.valueholder.NamedValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Observation {
    public static final String PROP_SOURCE = "source";
    public static final String PROP_CODE = "code";
    public static final String PROP_TEXT = "text";
    public static final String PROP_CREATED = "created";
    private static String CategoryPrefix = "observation";
    private String source;
    private IMessage message;
    private final List<INamedValue> properties = new ArrayList<INamedValue>();

    public static ObservationBuilder builder() {
        return new ObservationBuilder();
    }

    public Observation() {
        this.putProperty(PROP_CREATED, System.currentTimeMillis());
    }

    public IMessage getMessage() {
        return this.message;
    }

    public List<INamedValue> getProperties() {
        return this.properties;
    }

    protected Object[] getPropertiesArray() {
        return this.getProperties().toArray(new Object[this.getProperties().size()]);
    }

    public Object getProperty(String pName) {
        for (INamedValue namedValue : this.properties) {
            if (!namedValue.getName().equals(pName)) continue;
            return namedValue.get();
        }
        return null;
    }

    public String getSource() {
        return this.source;
    }

    public void publish() {
        String category = CategoryPrefix + "." + this.getSource();
        Logger logger = LoggerFactory.getLogger((String)category);
        logger.info(this.getMessage().getString(), this.getPropertiesArray());
    }

    public void putProperty(String pName, Object pValue) {
        this.properties.add((INamedValue)new NamedValue(pName, pValue));
    }

    public void setMessage(IMessage message) {
        this.message = message;
        this.putProperty(PROP_CODE, message.getCode());
        String messageString = message.getString();
        this.putProperty(PROP_TEXT, messageString);
    }

    public void setSource(String source) {
        this.source = source;
        this.putProperty(PROP_SOURCE, source);
    }

    public static class ObservationBuilder {
        private Observation value = new Observation();

        public Observation build() {
            return this.value;
        }

        public ObservationBuilder message(IMessage message) {
            this.value.setMessage(message);
            return this;
        }

        public ObservationBuilder put(String pName, Object pValue) {
            this.value.getProperties().add((INamedValue)new NamedValue(pName, pValue));
            return this;
        }

        public ObservationBuilder putAll(Map<String, Object> pValues) {
            if (pValues != null) {
                for (Map.Entry<String, Object> entry : pValues.entrySet()) {
                    this.put(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        public ObservationBuilder source(String source) {
            this.value.setSource(source);
            return this;
        }
    }
}

