/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.ais.app.signature;

import com.swisscom.ais.service.IDigitalSignatureService;
import de.intarsys.ais.SignRequestBuilder;
import de.intarsys.ais.SignatureStandard;
import de.intarsys.security.app.signature.CommonBatchSigner;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.ais.app.signature.PACKAGE;
import de.intarsys.security.device.ais.common.AisEnvironment;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.method.xml.common.XMLDSigTools;
import de.intarsys.security.signature.common.ExtendedSignatureData;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.SignatureTask;
import de.intarsys.security.signature.etsi.api.SignatureFormat;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.exception.TunnelingException;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import oasis.names.tc.dss._1_0.core.schema.ClaimedIdentity;
import oasis.names.tc.dss._1_0.core.schema.SignRequest;

public abstract class AisAbstractSigner
extends CommonBatchSigner {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    public static final Collection<String> SUPPORTED_DIGEST_ALGORITHMS = Collections.unmodifiableList(Arrays.asList("SHA-256", "SHA-384", "SHA-512"));
    public static final String ARGV_MODE_ON_DEMAND_SYNC = "onDemandSync";
    public static final String ARGV_MODE_ON_DEMAND = "onDemand";
    public static final String ARGV_MODE_STATIC = "static";
    public static final String ARG_MODE = "mode";
    public static final String ARG_ADDOCSPRESPONSE = "addOcspResponse";
    public static final String ARG_ADDREVOCATIONINFORMATION = "addRevocationInformation";
    public static final String ARG_KEYENTITY = "keyEntity";
    public static final String ARG_REQUESTID = "requestId";
    public static final String ARG_RASASSURANCELEVEL = "rasAssuranceLevel";
    public static final String ARG_RASJURISDICTION = "rasJurisdiction";
    private boolean addOcspResponse;
    private boolean addRevocationInformation;
    private String keyEntity;
    private String requestId;
    private int rasAssuranceLevel;
    private String rasJurisdiction;
    private IDigitalSignatureService service;
    private String customerName;

    protected AisAbstractSigner(CommonDevice<?> device) {
        super(device);
        this.setApproximatedContainerSize(-1);
    }

    protected SignRequest buildRequest() {
        SignRequestBuilder builder = new SignRequestBuilder();
        this.buildRequest(builder);
        return (SignRequest)builder.getBaseRequest();
    }

    protected void buildRequest(SignRequestBuilder builder) {
        List tempTasks = this.getTasks();
        if (tempTasks.isEmpty()) {
            throw new IllegalStateException("No tasks available.");
        }
        ((SignRequestBuilder)((SignRequestBuilder)builder.withRequestID(this.getRequestId())).withSwisscomProfile()).withClaimedIdentity(this.getCustomerName(), this.keyEntity);
        if (tempTasks.size() > 1) {
            builder.withAdditionalProfileBatchProcessing();
        }
        int index = 0;
        for (SignatureTask task : tempTasks) {
            try {
                IDigest digest = DigestTools.createDigest((byte[])task.toBeSignedData.getEncodedDigest());
                builder.withDocumentHash(String.valueOf(index), XMLDSigTools.lookupDigestAlgorithm((String)digest.getAlgorithmName()).getName(), digest.getBytes());
            }
            catch (IOException e) {
                throw ExceptionTools.wrap((Throwable)e);
            }
            ++index;
        }
        SignatureFormat signatureFormat = this.getSignatureFormat();
        if (signatureFormat == SignatureFormat.CAdES) {
            builder.withSignatureStandard(SignatureStandard.cades);
        } else if (signatureFormat == SignatureFormat.PAdES) {
            builder.withSignatureStandard(SignatureStandard.pades_baseline);
        }
        if (this.isRequestRevocationInformation()) {
            builder.withAddRevocationInformation();
        } else if (this.addOcspResponse) {
            builder.withAddOcspResponse("urn:ietf:rfc:2560");
        }
        if (this.getSignatureOptions().isAddTimestamp() && !this.getSignatureOptions().hasTimestampCreator()) {
            builder.withAddTimestamp("urn:ietf:rfc:3161");
        }
    }

    protected ISignatureData convertSignature(byte[] response, IExtendedValidationData aisValidationData) {
        try {
            return ExtendedSignatureData.create((byte[])response, null, (IExtendedValidationData)aisValidationData);
        }
        catch (Exception e) {
            throw new TunnelingException((Throwable)e);
        }
    }

    protected IPrincipal createPrincipal(IX509PublicKeyCertificate certificate) {
        return null;
    }

    public int getApproximatedContainerSize() {
        int explicitSize = super.getApproximatedContainerSize();
        if (explicitSize != -1) {
            return explicitSize;
        }
        int size = 8192;
        if (this.isRevocationInformationInCMS()) {
            size += 12288;
        }
        if (this.getSignatureOptions().isAddTimestamp()) {
            size += 12288;
        }
        return Math.min(Short.MAX_VALUE, size);
    }

    protected String getClaimedIdentity(SignRequest signRequest) {
        String identityString = null;
        for (Object object : signRequest.getOptionalInputs().getAny()) {
            if (!(object instanceof ClaimedIdentity)) continue;
            ClaimedIdentity claimedIdentity = (ClaimedIdentity)object;
            identityString = claimedIdentity.getName().getValue();
        }
        return identityString;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public String getEncryptionAlgorithmName() {
        return "RSA";
    }

    protected String getKeyEntity() {
        return this.keyEntity;
    }

    public String getLabel() {
        AisEnvironment environment = AisEnvironment.get();
        return Msg.getString("AisOnDemandSigner.label", new Object[]{environment.getServiceAddress()});
    }

    public int getRasAssuranceLevel() {
        return this.rasAssuranceLevel;
    }

    public String getRasJurisdiction() {
        return this.rasJurisdiction;
    }

    public String getRequestId() {
        if (this.requestId == null) {
            this.requestId = UUID.randomUUID().toString();
        }
        return this.requestId;
    }

    public IDigitalSignatureService getService() {
        return this.service;
    }

    public Collection<String> getSupportedHashAlgorithmNames() {
        return SUPPORTED_DIGEST_ALGORITHMS;
    }

    public boolean isBasic() {
        return false;
    }

    protected boolean isRequestRevocationInformation() {
        return this.addRevocationInformation || this.getSignatureOptions().getValidationDataOptions().isAddValidationData();
    }

    protected boolean isRevocationInformationInCMS() {
        if (this.getSignatureFormat() == SignatureFormat.PAdES) {
            return false;
        }
        return this.isRequestRevocationInformation() || this.addOcspResponse;
    }

    public void setAddOcspResponse(boolean addOcspResponse) {
        this.addOcspResponse = addOcspResponse;
    }

    public void setAddRevocationInformation(boolean addRevocationInformation) {
        this.addRevocationInformation = addRevocationInformation;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public void setKeyEntity(String keyEntity) {
        this.keyEntity = keyEntity;
    }

    public void setRasAssuranceLevel(int rasAssuranceLevel) {
        this.rasAssuranceLevel = rasAssuranceLevel;
    }

    public void setRasJurisdiction(String rasJurisdiction) {
        this.rasJurisdiction = rasJurisdiction;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setService(IDigitalSignatureService service) {
        this.service = service;
    }
}

