/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.ais.app.signature;

import ch.swisscom.ais._1_0.schema.RevocationInformationType;
import com.swisscom.ais.service.Pending;
import com.swisscom.ais.service.PendingResponse;
import de.intarsys.ais.PendingRequestBuilder;
import de.intarsys.ais.PendingResponseFacade;
import de.intarsys.ais.ResultException;
import de.intarsys.ais.SignRequestBuilder;
import de.intarsys.ais.SignResponseFacadeSignature;
import de.intarsys.security.app.AuthenticationCanceled;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.device.ais.app.signature.AisOnDemandSigner;
import de.intarsys.security.device.ais.app.signature.AisValidationData;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IReplyStage;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.conversation.impl.HttpRedirectStage;
import de.intarsys.tools.conversation.impl.ProcessingStage;
import de.intarsys.tools.zones.Zone;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import oasis.names.tc.dss._1_0.core.schema.Result;
import oasis.names.tc.dss._1_0.core.schema.SignRequest;
import oasis.names.tc.dss._1_0.core.schema.SignResponse;
import oasis.names.tc.dss._1_0.profiles.asynchronousprocessing._1.PendingRequest;

public class AisAsyncOnDemandSigner
extends AisOnDemandSigner {
    private static final String RESULTMINOR_STEP_UP_CANCEL = "http://ais.swisscom.ch/1.1/resultminor/subsystem/StepUp/cancel";
    private Conversation conversation;
    private boolean consentUrlHandled = false;

    public AisAsyncOnDemandSigner(CommonDevice device) {
        super(device);
    }

    protected void basicDispose() {
        super.basicDispose();
        if (this.getConversation() != null) {
            this.getConversation().cancel(false);
        }
    }

    protected IConversation<?> basicSignAuthorized() {
        try {
            SignRequest signRequest = this.buildRequest();
            SignResponse signResponse = this.getService().sign(signRequest);
            String identityString = this.getClaimedIdentity(signRequest);
            this.setConversation(new Conversation("aisSigner"));
            this.updateState(identityString, signResponse);
            return this.getConversation();
        }
        catch (Exception ex) {
            return Conversation.failed((Throwable)new SecurityApplicationException((Throwable)ex));
        }
    }

    @Override
    protected void buildRequest(SignRequestBuilder builder) {
        super.buildRequest(builder);
        builder.withAdditionalProfileAsync().withAdditionalProfileRedirect();
    }

    protected void checkAndUpdateState(String identityString, String responseId) {
        try {
            this.updateState(identityString, this.checkPendingSignature(identityString, responseId));
        }
        catch (Exception e) {
            this.getConversation().completeExceptionally((Throwable)new SecurityApplicationException((Throwable)e));
        }
    }

    protected SignResponse checkPendingSignature(String identityString, String responseId) {
        PendingRequestBuilder builder = new PendingRequestBuilder();
        ((PendingRequestBuilder)((PendingRequestBuilder)builder.withSwisscomProfile()).withClaimedIdentity(identityString)).withResponseID(responseId);
        PendingRequest pendingRequest = (PendingRequest)builder.getBaseRequest();
        Pending pending = new Pending();
        pending.setPendingRequest(pendingRequest);
        PendingResponse pendingResponse = this.getService().pending(pending);
        return pendingResponse.getSignResponse();
    }

    protected Conversation getConversation() {
        return this.conversation;
    }

    protected void setConversation(Conversation conversation) {
        this.conversation = conversation;
    }

    protected void updateState(String identityString, SignResponse signResponse) {
        try {
            SignResponseFacadeSignature signResponseFacadeSignature = new SignResponseFacadeSignature(signResponse);
            RevocationInformationType revocationInformation = signResponseFacadeSignature.getOptionalOutputRevocationInformation();
            List signatures = signResponseFacadeSignature.getSignatures().stream().map(bytes -> this.convertSignature((byte[])bytes, revocationInformation == null ? null : new AisValidationData(revocationInformation))).collect(Collectors.toList());
            this.tasksComplete(signatures);
            this.getConversation().complete(null);
            return;
        }
        catch (ResultException signResponseFacadeSignature) {
        }
        catch (Exception ex) {
            this.getConversation().completeExceptionally((Throwable)ex);
            return;
        }
        try {
            PendingResponseFacade pendingResponseFacade = new PendingResponseFacade(signResponse);
            String consentUrl = pendingResponseFacade.getConsentUrl();
            String responseId = pendingResponseFacade.getResponseID();
            if (consentUrl == null || this.consentUrlHandled) {
                this.updateStateToProcessing(identityString, responseId);
            } else {
                this.updateStateToRedirect(identityString, responseId, consentUrl);
            }
        }
        catch (ResultException ex) {
            Result result = ex.getResult();
            if (RESULTMINOR_STEP_UP_CANCEL.equals(result.getResultMinor())) {
                this.getConversation().completeExceptionally((Throwable)new AuthenticationCanceled(ex.getMessage(), (Throwable)ex));
            }
            this.getConversation().completeExceptionally((Throwable)ex);
        }
    }

    protected void updateStateToProcessing(String identityString, String responseId) {
        ProcessingStage replyStage = new ProcessingStage(this.getProcessingMessageExpanded());
        Consumer ack = Zone.getCurrent().wrap(response -> this.checkAndUpdateState(identityString, responseId));
        replyStage.onAck(ack);
        this.getConversation().setReplyStage((IReplyStage)replyStage);
    }

    protected void updateStateToRedirect(String identityString, String responseId, String consentUrl) {
        HttpRedirectStage replyStage = new HttpRedirectStage(consentUrl, true, false);
        Consumer ack = Zone.getCurrent().wrap(response -> {
            this.consentUrlHandled = true;
            this.updateStateToProcessing(identityString, responseId);
        });
        replyStage.onAck(ack);
        this.getConversation().setReplyStage((IReplyStage)replyStage);
    }
}

