/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.ais.app.signature;

import de.intarsys.ais.SignRequestBuilder;
import de.intarsys.security.device.ais.app.signature.AisAbstractSigner;
import de.intarsys.security.device.ais.app.signature.GSMTools;
import de.intarsys.security.device.ais.app.signature.PACKAGE;
import de.intarsys.security.device.ais.device.AisDevice;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AisOnDemandSigner
extends AisAbstractSigner {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(AisOnDemandSigner.class);
    public static final String ARG_DISTINGUISHEDNAME = "distinguishedName";
    public static final String ARG_MOBILEIDLANGUAGE = "mobileIDLanguage";
    public static final String ARG_MOBILEIDMESSAGE = "mobileIDMessage";
    public static final String ARG_MOBILEIDMSISDN = "mobileIDMSISDN";
    public static final String ARG_STEPUPLANGUAGE = "stepUpLanguage";
    public static final String ARG_STEPUPMESSAGE = "stepUpMessage";
    public static final String ARG_STEPUPMESSAGE_MAXLENGTH = "stepUpMessageMaxLength";
    public static final String ARG_STEPUPMESSAGE_MAXLENGTH_NONGSM = "stepUpMessageMaxLengthNonGSM";
    public static final String ARG_STEPUPMSISDN = "stepUpMSISDN";
    public static final int DEFAULT_STEPUPMESSAGE_MAXLENGTH = 239;
    public static final int DEFAULT_STEPUPMESSAGE_MAXLENGTH_NONGSM = 119;
    private String distinguishedName;
    private String stepUpLanguage;
    private String stepUpMessage;
    private int stepUpMessageMaxLength = 239;
    private int stepUpMessageMaxLengthNonGSM = 119;
    private String stepUpMSISDN;

    public AisOnDemandSigner(CommonDevice device) {
        super(device);
    }

    @Override
    protected void buildRequest(SignRequestBuilder builder) {
        super.buildRequest(builder);
        builder.withAdditionalProfileOnDemand();
        if (this.getStepUpMSISDN() == null) {
            builder.withCertificateRequest(this.expand(this.getDistinguishedName()));
        } else {
            String stepUpMessage = this.getStepUpMessage();
            if (!StringTools.isEmpty((String)stepUpMessage)) {
                stepUpMessage = this.expand(stepUpMessage);
                stepUpMessage = this.shortenStepUpMessage(stepUpMessage);
            }
            builder.withCertificateRequest(this.expand(this.getDistinguishedName()), this.expand(this.getStepUpLanguage()), stepUpMessage, this.expand(this.getStepUpMSISDN()));
        }
    }

    public String getDistinguishedName() {
        return this.distinguishedName;
    }

    @Override
    public String getLabel() {
        AisDevice device = (AisDevice)this.getDevice();
        return Msg.getString("AisOnDemandSigner.label", new Object[]{device.getServiceAddress()});
    }

    public String getStepUpLanguage() {
        return this.stepUpLanguage;
    }

    public String getStepUpMessage() {
        return this.stepUpMessage;
    }

    public int getStepUpMessageMaxLength() {
        return this.stepUpMessageMaxLength;
    }

    public int getStepUpMessageMaxLengthNonGSM() {
        return this.stepUpMessageMaxLengthNonGSM;
    }

    public String getStepUpMSISDN() {
        return this.stepUpMSISDN;
    }

    public void setDistinguishedName(String distinguishedName) {
        this.distinguishedName = distinguishedName;
    }

    public void setStepUpLanguage(String stepUpLanguage) {
        this.stepUpLanguage = stepUpLanguage;
    }

    public void setStepUpMessage(String stepUpMessage) {
        this.stepUpMessage = stepUpMessage;
    }

    public void setStepUpMessageMaxLength(int stepUpMessageMaxLength) {
        this.stepUpMessageMaxLength = stepUpMessageMaxLength;
    }

    public void setStepUpMessageMaxLengthNonGSM(int stepUpMessageMaxLengthNonGSM) {
        this.stepUpMessageMaxLengthNonGSM = stepUpMessageMaxLengthNonGSM;
    }

    public void setStepUpMSISDN(String stepUpMSISDN) {
        this.stepUpMSISDN = stepUpMSISDN;
    }

    protected String shortenStepUpMessage(String stepUpMessage) {
        int maxLength = this.getStepUpMessageMaxLength();
        int maxLengthNonGsm = this.getStepUpMessageMaxLengthNonGSM();
        if (maxLengthNonGsm == -1) {
            maxLengthNonGsm = maxLength;
        }
        if (GSMTools.usesGsm03_38CharacterSet(stepUpMessage)) {
            if (maxLength > -1) {
                return StringTools.getLeading((String)stepUpMessage, (int)maxLength);
            }
        } else if (maxLengthNonGsm > -1) {
            return StringTools.getLeading((String)stepUpMessage, (int)maxLengthNonGsm);
        }
        return stepUpMessage;
    }
}

