/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.ais.app.signature;

import de.intarsys.ais.BaseRequestBuilder;
import de.intarsys.ras.Evidence;
import de.intarsys.ras.EvidenceValidationPost;
import de.intarsys.ras.EvidenceVerificationException;
import de.intarsys.ras.RasClient;
import de.intarsys.security.app.signature.CommonSignerFactory;
import de.intarsys.security.device.ais.app.signature.AisAbstractSigner;
import de.intarsys.security.device.ais.app.signature.AisAsyncOnDemandSigner;
import de.intarsys.security.device.ais.app.signature.AisOnDemandSigner;
import de.intarsys.security.device.ais.app.signature.AisStaticSigner;
import de.intarsys.security.device.ais.app.signature.AisSyncOnDemandSigner;
import de.intarsys.security.device.ais.app.signature.PACKAGE;
import de.intarsys.security.device.ais.common.AisEnvironment;
import de.intarsys.security.device.ais.device.AisDevice;
import de.intarsys.security.device.ais.device.AisDeviceTools;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.expression.ReflectiveResolver;
import de.intarsys.tools.expression.ResolveProperty;
import de.intarsys.tools.expression.ScopedResolver;
import de.intarsys.tools.expression.StaticArgsResolver;
import de.intarsys.tools.expression.StringEvaluatorTools;
import de.intarsys.tools.expression.TaggedStringEvaluator;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AisSignerFactory
extends CommonSignerFactory<AisDevice, AisAbstractSigner> {
    private static final Logger Log = LoggerFactory.getLogger(AisSignerFactory.class);
    public static final String ARG_RAS_EVIDENCE = "rasEvidence";
    protected static final String MSG_ARG_INVALID = "AisSignerFactory.errorArgInvalid";
    private static IMessageBundle Msg = PACKAGE.Messages;

    protected AisAbstractSigner basicCreateApp(IArgs args) throws ObjectCreationException {
        String mode = ArgTools.getString((IArgs)args, (String)"mode", null);
        if ("static".equals(mode)) {
            AisStaticSigner signer = new AisStaticSigner(this.getDevice(args));
            this.configureSignerStatic(signer, args);
            return signer;
        }
        if ("onDemandSync".equals(mode)) {
            AisSyncOnDemandSigner signer = new AisSyncOnDemandSigner(this.getDevice(args));
            this.configureSignerOnDemand(signer, args);
            return signer;
        }
        if ("onDemand".equals(mode)) {
            AisAsyncOnDemandSigner signer = new AisAsyncOnDemandSigner(this.getDevice(args));
            this.configureSignerOnDemand(signer, args);
            return signer;
        }
        throw new ObjectCreationException((Throwable)new IllegalArgumentException("mode '" + mode + "' not supported"));
    }

    protected void configureSigner(AisAbstractSigner signer, IArgs args) {
        signer.setAddOcspResponse(this.isAddOcspResponse(args));
        signer.setAddRevocationInformation(this.isAddRevocationInformation(args));
        signer.setKeyEntity(this.getKeyEntity(args));
        signer.setService(AisDeviceTools.getService(args));
        signer.setCustomerName(AisDeviceTools.getCustomerName(args));
        signer.setRequestId(this.getRequestId(args));
        signer.setRasAssuranceLevel(this.getRasAssuranceLevel(args));
        signer.setRasJurisdiction(this.getRasJurisdiction(args));
    }

    protected void configureSignerOnDemand(AisOnDemandSigner signer, IArgs args) throws ObjectCreationException {
        RasEvidenceResolver serviceResolver;
        this.configureSigner(signer, args);
        String distinguishedName = this.getDistinguishedName(args);
        signer.setDistinguishedName(distinguishedName);
        signer.setStepUpLanguage(this.getStepUpLanguage(args));
        signer.setStepUpMessage(this.getStepUpMessage(args));
        signer.setStepUpMessageMaxLength(this.getStepUpMessageMaxLength(args));
        signer.setStepUpMessageMaxLengthNonGSM(this.getStepUpMessageMaxLengthNonGSM(args));
        signer.setStepUpMSISDN(this.getStepUpMSISDN(args));
        RasEvidenceResolver evidenceResolver = serviceResolver = new RasEvidenceResolver(signer);
        if (args.isDefined(ARG_RAS_EVIDENCE)) {
            IArgs raArgs = ArgTools.getArgs((IArgs)args, (String)ARG_RAS_EVIDENCE, (IArgs)Args.create());
            evidenceResolver = ScopedResolver.create((IStringEvaluator[])new IStringEvaluator[]{new StaticArgsResolver(raArgs), serviceResolver});
        }
        MapResolver resolver = MapResolver.create((String)ARG_RAS_EVIDENCE, (IStringEvaluator)evidenceResolver);
        TaggedStringEvaluator evaluator = TaggedStringEvaluator.decorateLenient((IStringEvaluator[])new IStringEvaluator[]{resolver});
        distinguishedName = StringEvaluatorTools.evaluateString((IStringEvaluator)evaluator, (String)distinguishedName);
        if (serviceResolver.getThrowable() != null) {
            throw new ObjectCreationException("The signer information could not be verified.", serviceResolver.getThrowable());
        }
        signer.setDistinguishedName(distinguishedName);
    }

    protected void configureSignerStatic(AisStaticSigner signer, IArgs args) {
        this.configureSigner(signer, args);
    }

    protected String getArgNamePassword() {
        return "signerPassword";
    }

    protected String getDistinguishedName(IArgs args) {
        String distinguishedName = ArgTools.getString((IArgs)args, (String)"distinguishedName", null);
        if (distinguishedName == null) {
            throw new IllegalArgumentException(Msg.getString(MSG_ARG_INVALID, new Object[]{"distinguishedName"}));
        }
        return distinguishedName;
    }

    protected String getKeyEntity(IArgs args) {
        return ArgTools.getString((IArgs)args, (String)"keyEntity", null);
    }

    protected int getRasAssuranceLevel(IArgs args) {
        return ArgTools.getIntStrict((IArgs)args, (String)"rasAssuranceLevel", (int)4);
    }

    protected String getRasJurisdiction(IArgs args) {
        return ArgTools.getString((IArgs)args, (String)"rasJurisdiction", null);
    }

    protected String getRequestId(IArgs args) {
        return ArgTools.getString((IArgs)args, (String)"requestId", null);
    }

    public Class<AisAbstractSigner> getResultType() {
        return AisAbstractSigner.class;
    }

    protected String getStepUpLanguage(IArgs args) {
        String stepUpLanguage = ArgTools.getString((IArgs)args, (String)"stepUpLanguage", null);
        if (stepUpLanguage == null && (stepUpLanguage = ArgTools.getString((IArgs)args, (String)"mobileIDLanguage", null)) != null) {
            args.undefine("mobileIDLanguage");
            args.put("stepUpLanguage", (Object)stepUpLanguage);
        }
        if (this.getStepUpMSISDN(args) == null ^ stepUpLanguage == null) {
            throw new IllegalArgumentException(Msg.getString(MSG_ARG_INVALID, new Object[]{"stepUpLanguage"}));
        }
        return stepUpLanguage;
    }

    protected String getStepUpMessage(IArgs args) {
        String stepUpMessage = ArgTools.getString((IArgs)args, (String)"stepUpMessage", null);
        if (stepUpMessage == null && (stepUpMessage = ArgTools.getString((IArgs)args, (String)"mobileIDMessage", null)) != null) {
            args.undefine("mobileIDMessage");
            args.put("stepUpMessage", (Object)stepUpMessage);
        }
        if (this.getStepUpMSISDN(args) == null ^ stepUpMessage == null) {
            throw new IllegalArgumentException(Msg.getString(MSG_ARG_INVALID, new Object[]{"stepUpMessage"}));
        }
        return stepUpMessage;
    }

    protected int getStepUpMessageMaxLength(IArgs args) {
        block3: {
            try {
                int stepUpMessageLength = ArgTools.getIntStrict((IArgs)args, (String)"stepUpMessageMaxLength", (int)239);
                if (stepUpMessageLength >= -1) {
                    return stepUpMessageLength;
                }
                Log.warn("invalid value '{}' for stepUpMessageLength", (Object)stepUpMessageLength);
            }
            catch (IllegalArgumentException ex) {
                Object arg = args.get("stepUpMessageMaxLength");
                if (arg instanceof String && StringTools.isEmpty((String)((String)arg))) break block3;
                Log.warn(ex.getMessage());
            }
        }
        return 239;
    }

    protected int getStepUpMessageMaxLengthNonGSM(IArgs args) {
        block3: {
            try {
                int stepUpMessageLength = ArgTools.getIntStrict((IArgs)args, (String)"stepUpMessageMaxLengthNonGSM", (int)119);
                if (stepUpMessageLength >= -1) {
                    return stepUpMessageLength;
                }
                Log.warn("invalid value '{}' for stepUpMessageLengthNonGSM", (Object)stepUpMessageLength);
            }
            catch (IllegalArgumentException ex) {
                Object arg = args.get("stepUpMessageMaxLengthNonGSM");
                if (arg instanceof String && StringTools.isEmpty((String)((String)arg))) break block3;
                Log.warn(ex.getMessage());
            }
        }
        return 119;
    }

    protected String getStepUpMSISDN(IArgs args) {
        String stepUpMSISDN = ArgTools.getString((IArgs)args, (String)"stepUpMSISDN", null);
        if (stepUpMSISDN == null && (stepUpMSISDN = ArgTools.getString((IArgs)args, (String)"mobileIDMSISDN", null)) != null) {
            args.undefine("mobileIDMSISDN");
            args.put("stepUpMSISDN", (Object)stepUpMSISDN);
        }
        return stepUpMSISDN;
    }

    protected boolean isAddOcspResponse(IArgs args) {
        return ArgTools.getBoolStrict((IArgs)args, (String)"addOcspResponse", (boolean)false);
    }

    protected boolean isAddRevocationInformation(IArgs args) {
        return ArgTools.getBoolStrict((IArgs)args, (String)"addRevocationInformation", (boolean)false);
    }

    public static class RasEvidenceResolver
    implements IStringEvaluator {
        private static TaggedStringEvaluator PreprocessingEvaluator;
        private Evidence cachedEvidence;
        private IStringEvaluator nestedResolver;
        private AisOnDemandSigner signer;
        private Throwable throwable;

        public RasEvidenceResolver(AisOnDemandSigner signer) {
            this.signer = signer;
            this.nestedResolver = new ReflectiveResolver((Object)this);
        }

        public Object evaluate(String expression, IArgs args) throws EvaluationException {
            try {
                return this.nestedResolver.evaluate(expression, args);
            }
            catch (EvaluationException ex) {
                if (ex.getCause() instanceof InvocationTargetException) {
                    this.throwable = ((InvocationTargetException)ex.getCause()).getTargetException();
                }
                throw ex;
            }
        }

        protected Evidence getCachedEvidence() {
            if (this.cachedEvidence == null) {
                EvidenceValidationPost body = new EvidenceValidationPost();
                body.setAssuranceLevel(Integer.valueOf(this.signer.getRasAssuranceLevel()));
                body.setJurisdiction(this.signer.getRasJurisdiction());
                body.setClaimedIdentity(BaseRequestBuilder.FormatClaimedIdentity.format(new Object[]{this.signer.getCustomerName(), this.signer.getKeyEntity()}));
                String distinguishedName = this.signer.getDistinguishedName();
                distinguishedName = StringEvaluatorTools.evaluateString((IStringEvaluator)PreprocessingEvaluator, (String)distinguishedName);
                body.setDistinguishedName(this.signer.expand(distinguishedName));
                body.setMsisdn(this.signer.expand(this.signer.getStepUpMSISDN()));
                RasClient rasClient = AisEnvironment.get().getRasClient();
                try {
                    this.cachedEvidence = rasClient.evidencesVerifyPost(body);
                }
                catch (EvidenceVerificationException e) {
                    String message = e.getMessage();
                    if (message == null) {
                        message = "No evidence found - please check user data.";
                    }
                    throw new RuntimeException(message, e);
                }
            }
            return this.cachedEvidence;
        }

        @ResolveProperty(property="evidenceId")
        public String getEvidenceId() {
            return this.getCachedEvidence().getEvidenceId();
        }

        @ResolveProperty(property="serialNumber")
        public String getSerialNumber() {
            return this.getCachedEvidence().getSerialNumber();
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        @ResolveProperty(property="vetterMsisdn")
        public String getVetterMsisdn() {
            return this.getCachedEvidence().getVetterMsisdn();
        }

        static {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("evidenceId", "");
            map.put("serialNumber", "");
            map.put("vetterMsisdn", "");
            MapResolver preprocessingResolver = new MapResolver(Collections.singletonMap(AisSignerFactory.ARG_RAS_EVIDENCE, map));
            PreprocessingEvaluator = TaggedStringEvaluator.decorateLenient((IStringEvaluator[])new IStringEvaluator[]{preprocessingResolver});
        }
    }
}

