/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.ais.app.signature;

import ch.swisscom.ais._1_0.schema.RevocationInformationType;
import com.swisscom.ais.service.IDigitalSignatureService;
import de.intarsys.ais.SignResponseFacadeSignature;
import de.intarsys.security.device.ais.app.signature.AisAbstractSigner;
import de.intarsys.security.device.ais.app.signature.AisValidationData;
import de.intarsys.security.device.ais.app.signature.PACKAGE;
import de.intarsys.security.device.ais.device.AisDevice;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.message.IMessageBundle;
import java.util.List;
import java.util.stream.Collectors;
import oasis.names.tc.dss._1_0.core.schema.SignRequest;
import oasis.names.tc.dss._1_0.core.schema.SignResponse;

public class AisStaticSigner
extends AisAbstractSigner {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    public AisStaticSigner(CommonDevice device) {
        super(device);
    }

    protected IConversation<?> basicSignAuthorized() {
        IDigitalSignatureService service = this.getService();
        SignRequest signRequest = this.buildRequest();
        try {
            SignResponse signResponse = service.sign(signRequest);
            SignResponseFacadeSignature facadeSignature = new SignResponseFacadeSignature(signResponse);
            RevocationInformationType revocationInformation = facadeSignature.getOptionalOutputRevocationInformation();
            List signatures = facadeSignature.getSignatures().stream().map(bytes -> this.convertSignature((byte[])bytes, revocationInformation == null ? null : new AisValidationData(revocationInformation))).collect(Collectors.toList());
            this.tasksComplete(signatures);
            return Conversation.completed(null);
        }
        catch (Exception ex) {
            return Conversation.failed((Throwable)ex);
        }
    }

    @Override
    public String getLabel() {
        AisDevice device = (AisDevice)this.getDevice();
        return Msg.getString("AisStaticSigner.label", new Object[]{device.getServiceAddress()});
    }
}

