/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.ais.app.signature;

import ch.swisscom.ais._1_0.schema.CRLList;
import ch.swisscom.ais._1_0.schema.OCSPList;
import ch.swisscom.ais._1_0.schema.RevocationInformationType;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.ocsp.common.OCSPResponse;
import de.intarsys.security.validation.IExtendedValidationData;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRLException;
import java.util.stream.Stream;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;

public class AisValidationData
implements IExtendedValidationData {
    private RevocationInformationType revocationInfo;

    public AisValidationData(RevocationInformationType revocationInfo) {
        this.revocationInfo = revocationInfo;
    }

    public Stream<IX509PublicKeyCertificate> getCertificates() {
        return Stream.empty();
    }

    public Stream<IX509CRL> getCRLs() {
        CRLList crlList = this.revocationInfo.getCRLs();
        if (crlList == null) {
            return Stream.empty();
        }
        return crlList.getCRL().stream().map(value -> {
            IX509CRL iX509CRL;
            ByteArrayInputStream is = new ByteArrayInputStream((byte[])value);
            try {
                iX509CRL = X509CertificateFactory.get().createCRL((InputStream)is);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | CRLException e) {
                    throw new RuntimeException(e);
                }
            }
            ((InputStream)is).close();
            return iX509CRL;
        });
    }

    public Stream<IOCSPResponse> getOCSPResponses() {
        OCSPList ocspList = this.revocationInfo.getOCSPs();
        if (ocspList == null) {
            return Stream.empty();
        }
        return ocspList.getOCSP().stream().map(value -> {
            byte[] encBasicOCSPResp = org.bouncycastle.asn1.ocsp.OCSPResponse.getInstance((Object)value).getResponseBytes().getResponse().getOctets();
            return new OCSPResponse(new BasicOCSPResp(BasicOCSPResponse.getInstance((Object)encBasicOCSPResp)));
        });
    }
}

