/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.ais.app.timestamp;

import com.swisscom.ais.service.IDigitalSignatureService;
import de.intarsys.ais.AisClientException;
import de.intarsys.ais.SignRequestBuilder;
import de.intarsys.ais.SignResponseFacadeTimestamp;
import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1BasedTools;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.timestamp.CommonTimestampCreator;
import de.intarsys.security.app.timestamp.ITimestampRequest;
import de.intarsys.security.app.timestamp.ITimestampResponse;
import de.intarsys.security.app.timestamp.PlainTimestampResponse;
import de.intarsys.security.device.ais.device.AisDevice;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.method.cms.timestamp.TimestampToken;
import de.intarsys.security.method.xml.common.XMLDSigTools;
import de.intarsys.security.timestamp.ITimestampToken;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import java.io.IOException;
import oasis.names.tc.dss._1_0.core.schema.SignRequest;
import oasis.names.tc.dss._1_0.core.schema.SignResponse;

public class AisTimestampCreator
extends CommonTimestampCreator {
    protected AisTimestampCreator(CommonDevice device) {
        super(device);
    }

    protected byte[] basicCreateTimestamp(byte[] data) throws SecurityApplicationException {
        IDigitalSignatureService service = this.getDevice().getService();
        SignRequest signRequest = this.buildRequest(data);
        try {
            SignResponse signResponse = service.sign(signRequest);
            return new SignResponseFacadeTimestamp(signResponse).getTimestamp();
        }
        catch (AisClientException ex) {
            throw new SecurityApplicationException((Throwable)ex);
        }
    }

    private SignRequest buildRequest(byte[] data) {
        SignRequestBuilder builder = new SignRequestBuilder();
        this.buildRequest(data, builder);
        return (SignRequest)builder.getBaseRequest();
    }

    protected void buildRequest(byte[] data, SignRequestBuilder builder) {
        IDigest digest;
        try {
            digest = DigestTools.createDigest((byte[])data);
        }
        catch (IOException e) {
            throw new InternalError();
        }
        ((SignRequestBuilder)((SignRequestBuilder)builder.withSwisscomProfile()).withClaimedIdentity(this.getDevice().getCustomerName(), null)).withDocumentHash(XMLDSigTools.lookupDigestAlgorithm((String)digest.getAlgorithmName()).getName(), digest.getBytes()).withSignatureTypeTimestamp().withAdditionalProfileTimestamping();
    }

    public ITimestampResponse createTimestamp(ITimestampRequest request) throws SecurityApplicationException {
        try {
            byte[] bytes = this.basicCreateTimestamp(request.getEncoded());
            CMS cms = (CMS)ASN1BasedTools.create((ASN1Based.Factory)CMS.FACTORY, (byte[])bytes);
            ITimestampToken timestamp = TimestampToken.create((CMS)cms);
            return new PlainTimestampResponse(timestamp);
        }
        catch (IOException ex) {
            throw new SecurityApplicationException((Throwable)ex);
        }
    }

    public AisDevice getDevice() {
        return (AisDevice)super.getDevice();
    }
}

