/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.ais.common;

import com.swisscom.ais.service.IDigitalSignatureService;
import de.intarsys.ais.AisClient;
import de.intarsys.ras.RasClient;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.filter.CertificateFilterTools;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.provider.standard.IdCertificateProvider;
import de.intarsys.security.device.ais.common.PACKAGE;
import de.intarsys.security.privatekey.PrivateKeyProviderTools;
import de.intarsys.tools.authenticate.ConstantPasswordProvider;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.component.SingletonClass;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.IPreferencesSupport;
import de.intarsys.tools.preferences.IPreferencesSyncher;
import de.intarsys.tools.preferences.PreferencesFactory;
import de.intarsys.tools.preferences.PreferencesTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.security.KeyStoreTools;
import de.intarsys.tools.ssl.SslTools;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Iterator;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SingletonClass
public class AisEnvironment
implements IPreferencesSupport,
IPreferencesSyncher {
    private static final Logger Log = LoggerFactory.getLogger(AisEnvironment.class);
    private static IMessageBundle Msg = PACKAGE.Messages;
    private static final AisEnvironment ACTIVE = new AisEnvironment();
    public static final String PREF_CUSTOMER_NAME = "customerName";
    public static final String PREF_RAS_BASE_URI = "rasBaseUri";
    public static final String PREF_SERVICE_ADDRESS = "serviceAddress";
    public static final String PREF_SSL_CLIENT_CERT = "sslClientCert";
    public static final String PREF_SSL_CLIENT_CERT_PASSWORD = "sslClientCertPassword";
    public static final String DEFAULT_SERVICE_ADDRESS = "https://ais.swisscom.com/AIS-Server/ws";
    public static final String DEFAULT_RAS_BASE_URI = "https://ras.scapp.swisscom.com/api";
    private ThreadLocal<SoftReference<IDigitalSignatureService>> client = new ThreadLocal();
    private IPreferences preferences;
    private SoftReference<RasClient> rasClient;
    private String rasBaseUri;
    private KeyStore sslClientCert;
    private Secret sslClientCertPassword;
    private String serviceAddress;
    private String customerName;

    public static AisEnvironment get() {
        return ACTIVE;
    }

    public IDigitalSignatureService getClient() {
        IDigitalSignatureService service = null;
        SoftReference<IDigitalSignatureService> ref = this.client.get();
        if (ref != null) {
            service = ref.get();
        }
        if (service == null) {
            try {
                SSLContext sslContext = SslTools.createSslContext((KeyStore)this.getSslClientCert(), (Secret)this.getSslClientCertPassword());
                service = AisClient.create((String)this.getServiceAddress(), (SSLContext)sslContext);
                ref = new SoftReference<IDigitalSignatureService>(service);
                this.client.set(ref);
            }
            catch (Exception ex) {
                Log.warn(ex.getMessage(), (Throwable)ex);
            }
        }
        return service;
    }

    public String getCustomerName() {
        if (this.customerName != null) {
            return this.customerName;
        }
        String preferenceValue = this.getPreferences().get(PREF_CUSTOMER_NAME, null);
        if (preferenceValue != null) {
            return preferenceValue;
        }
        throw new IllegalStateException(Msg.getString("AisEnvironment.errorArgInvalid.customerName", new Object[0]));
    }

    public final IPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = PreferencesFactory.get().getRoot().node(this.getPreferencesName());
            this.preferencesInit(this.preferences.restrict("DEFAULT"));
        }
        return this.preferences;
    }

    protected String getPreferencesName() {
        return "de.intarsys.prefs.security.ais";
    }

    public String getRasBaseUri() {
        if (this.rasBaseUri != null) {
            return this.rasBaseUri;
        }
        String preferenceValue = this.getPreferences().get(PREF_RAS_BASE_URI, null);
        if (preferenceValue != null) {
            return preferenceValue;
        }
        throw new IllegalStateException(Msg.getString("AisEnvironment.errorArgInvalid.rasBaseUri", new Object[0]));
    }

    public RasClient getRasClient() {
        RasClient cachedRasClient = null;
        if (this.rasClient != null) {
            cachedRasClient = this.rasClient.get();
        }
        if (cachedRasClient == null) {
            cachedRasClient = new RasClient(this.getRasBaseUri());
            this.rasClient = new SoftReference<RasClient>(cachedRasClient);
        }
        return cachedRasClient;
    }

    public String getServiceAddress() {
        if (this.serviceAddress != null) {
            return this.serviceAddress;
        }
        String preferenceValue = this.getPreferences().get(PREF_SERVICE_ADDRESS, null);
        if (preferenceValue != null) {
            return preferenceValue;
        }
        throw new IllegalStateException(Msg.getString("AisEnvironment.errorArgInvalid.serviceAddress", new Object[0]));
    }

    public KeyStore getSslClientCert() {
        if (this.sslClientCert != null) {
            return this.sslClientCert;
        }
        String preferenceValue = this.getPreferences().get(PREF_SSL_CLIENT_CERT, null);
        try {
            IX509CertificateFilter filter = CertificateFilterTools.createCertificateFilter((Object)preferenceValue);
            Iterator certificates = IdCertificateProvider.get().lookupCertificates(filter);
            if (!certificates.hasNext()) {
                throw new IllegalStateException(Msg.getString("AisEnvironment.errorArgInvalid.sslClientCert", new Object[0]));
            }
            IX509PublicKeyCertificate certificate = (IX509PublicKeyCertificate)certificates.next();
            PrivateKey privateKey = PrivateKeyProviderTools.getKeyProvider((IX509PublicKeyCertificate)certificate).getPrivateKey(certificate, (IPasswordProvider)new ConstantPasswordProvider(this.getSslClientCertPassword()));
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, null);
            String alias = KeyStoreTools.createAlias((KeyStore)keyStore);
            keyStore.setKeyEntry(alias, privateKey, CryptoTools.getChars((Secret)this.getSslClientCertPassword()), new Certificate[]{certificate.toJavaCertificate()});
            keyStore.setCertificateEntry(CertificateTools.getSubjectLabel((IX509Certificate)certificate), certificate.toJavaCertificate());
            return keyStore;
        }
        catch (ObjectCreationException | IOException | GeneralSecurityException ex) {
            throw new IllegalStateException(Msg.getString("AisEnvironment.errorArgInvalid.sslClientCert", new Object[0]));
        }
    }

    public Secret getSslClientCertPassword() {
        if (this.sslClientCertPassword != null) {
            return this.sslClientCertPassword;
        }
        Secret preferenceValue = PreferencesTools.getSecret((IPreferences)this.getPreferences(), (String)PREF_SSL_CLIENT_CERT_PASSWORD, (Secret)Secret.EMPTY);
        if (CryptoTools.isEmpty((Secret)preferenceValue)) {
            throw new IllegalStateException(Msg.getString("AisEnvironment.errorArgInvalid.sslClientCertPassword", new Object[0]));
        }
        return preferenceValue;
    }

    protected void preferencesInit(IPreferences preferences) {
        preferences.put(PREF_SERVICE_ADDRESS, DEFAULT_SERVICE_ADDRESS);
    }

    public void preferencesRestore() {
    }

    public void preferencesStore() {
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public void setRasBaseUri(String rasBaseUri) {
        this.rasBaseUri = rasBaseUri;
    }

    public void setServiceAddress(String serviceAddress) {
        this.serviceAddress = serviceAddress;
    }

    public void setSslClientCert(KeyStore sslClientCert) {
        this.sslClientCert = sslClientCert;
    }

    public void setSslClientCertPassword(Secret sslClientCertPassword) {
        this.sslClientCertPassword = sslClientCertPassword;
    }
}

