/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.ais.device;

import com.swisscom.ais.service.IDigitalSignatureService;
import de.intarsys.security.device.ais.common.AisEnvironment;
import de.intarsys.security.device.ais.device.AisDeviceProvider;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.tools.factory.FactoredBy;
import de.intarsys.tools.functor.IArgs;

@FactoredBy(factory=AisDeviceProvider.class)
public class AisDevice
extends CommonDevice<AisDeviceProvider> {
    public static final String LIC_PRODUCT = "de.intarsys.security.device.ais";
    private IDigitalSignatureService service;
    private String serviceAddress;
    private String customerName;

    protected AisDevice(AisDeviceProvider deviceProvider, String name) {
        super((CommonDeviceProvider)deviceProvider, name);
    }

    public void configure(IArgs args) throws Exception {
        super.configure(args);
        this.setCustomerName(AisDeviceProvider.getCustomerName(args));
        this.setService(AisDeviceProvider.getService(args));
        this.setServiceAddress(AisDeviceProvider.getServiceAddress(args));
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public IDigitalSignatureService getService() {
        return this.service;
    }

    public String getServiceAddress() {
        if (this.serviceAddress == null) {
            return AisEnvironment.get().getServiceAddress();
        }
        return this.serviceAddress;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public void setService(IDigitalSignatureService service) {
        this.service = service;
    }

    public void setServiceAddress(String serviceAddress) {
        this.serviceAddress = serviceAddress;
    }
}

