/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.ais.device;

import com.swisscom.ais.service.IDigitalSignatureService;
import de.intarsys.ais.AisClient;
import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.app.IApplicationPolicy;
import de.intarsys.security.app.NoPolicy;
import de.intarsys.security.app.signature.CommonSignerPolicy;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.app.timestamp.ITimestampCreator;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.standard.X509CertificateSelector;
import de.intarsys.security.certificate.provider.CertificateProviderTools;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.standard.IdCertificateProvider;
import de.intarsys.security.certificate.provider.standard.PreselectCertificateProvider;
import de.intarsys.security.device.DeviceProviderRegistry;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.ais.app.signature.AisSignerFactory;
import de.intarsys.security.device.ais.app.timestamp.AisTimestampCreatorFactory;
import de.intarsys.security.device.ais.device.AisDevice;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.ssl.CertificateBasedKeyManagerProvider;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.LicenseProduct;
import de.intarsys.tools.license.LicensePropertyUnit;
import de.intarsys.tools.license.LicenseTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.ssl.IConfigurableSslContextProvider;
import de.intarsys.tools.ssl.IKeyManagerProvider;
import de.intarsys.tools.ssl.SslContextProvider;
import de.intarsys.tools.ssl.SslTools;
import jakarta.annotation.PostConstruct;
import java.net.MalformedURLException;
import java.util.List;
import javax.net.ssl.SSLContext;

public class AisDeviceProvider
extends CommonDeviceProvider<AisDevice> {
    public static final String ARG_SERVICE = "service";
    public static final String ARG_SERVICE_ADDRESS = "serviceAddress";
    public static final String ARG_SSL_CLIENT_CERT = "sslClientCert";
    public static final String ARG_SSL_CLIENT_CERT_STORE = "sslClientCertStore";
    public static final String ARG_SSL_CLIENT_CERT_PASSWORD = "sslClientCertPassword";
    public static final String ARG_CUSTOMER_NAME = "customerName";
    public static final String ARG_SSL_CONTEXT = "sslContext";

    protected static IDigitalSignatureService createService(IArgs args) throws MalformedURLException {
        String address = ArgTools.getString((IArgs)args, (String)ARG_SERVICE_ADDRESS, (String)"https://ais.swisscom.com/AIS-Server/ws");
        SSLContext sslContext = SslTools.getSslContext((IArgs)args, (String)ARG_SSL_CONTEXT);
        if (sslContext == null) {
            sslContext = AisDeviceProvider.createSslContext(args);
        }
        if (sslContext == null) {
            throw ExceptionTools.argumentRequired((String)ARG_SSL_CONTEXT);
        }
        return AisClient.create((String)address, (SSLContext)sslContext);
    }

    protected static SSLContext createSslContext(IArgs args) {
        ICertificateProvider certificateProvider;
        try {
            certificateProvider = CertificateProviderTools.getCertificateProvider((IArgs)args, (String)ARG_SSL_CLIENT_CERT_STORE, (ICertificateProvider)IdCertificateProvider.get());
        }
        catch (Exception e) {
            throw ExceptionTools.argumentInvalid((String)ARG_SSL_CLIENT_CERT_STORE, null, (Throwable)e);
        }
        X509CertificateSelector privateKeyCertificateProvider = new X509CertificateSelector();
        privateKeyCertificateProvider.setHasPrivateKey(Boolean.valueOf(true));
        certificateProvider = new PreselectCertificateProvider((IX509CertificateFilter)privateKeyCertificateProvider, certificateProvider);
        Secret password = ArgTools.getSecretHide((IArgs)args, (String)ARG_SSL_CLIENT_CERT_PASSWORD, null);
        Object selector = args.get(ARG_SSL_CLIENT_CERT);
        IConfigurableSslContextProvider sslContextProvider = SslContextProvider.get().createProvider();
        CertificateBasedKeyManagerProvider keyManagerProvider = new CertificateBasedKeyManagerProvider();
        keyManagerProvider.setCertificateProvider(certificateProvider);
        keyManagerProvider.setKeyPassword(password);
        keyManagerProvider.setSelector(selector);
        sslContextProvider.setKeyManagerProvider((IKeyManagerProvider)keyManagerProvider);
        try {
            return sslContextProvider.createSslContext();
        }
        catch (Exception e) {
            throw ExceptionTools.argumentInvalid((String)ARG_SSL_CLIENT_CERT, (String)"certificate not found or invalid", (Throwable)e);
        }
    }

    public static String getCustomerName(IArgs args) {
        return ArgTools.getString((IArgs)args, (String)ARG_CUSTOMER_NAME, null);
    }

    public static IDigitalSignatureService getService(IArgs args) {
        Object service = args.get(ARG_SERVICE);
        if (service == null) {
            return null;
        }
        if (service instanceof IDigitalSignatureService) {
            IDigitalSignatureService dssService = (IDigitalSignatureService)service;
            return dssService;
        }
        if (service instanceof IArgs) {
            IArgs serviceArgs = (IArgs)service;
            try {
                return AisDeviceProvider.createService(serviceArgs);
            }
            catch (MalformedURLException e) {
                throw ExceptionTools.argumentInvalid((String)ARG_SERVICE, null, (Throwable)e);
            }
        }
        throw ExceptionTools.argumentInvalid((String)ARG_SERVICE, null, null);
    }

    public static String getServiceAddress(IArgs args) {
        Object serviceObj = args.get(ARG_SERVICE);
        if (serviceObj == null) {
            return null;
        }
        if (serviceObj instanceof IArgs) {
            IArgs serviceArgs = (IArgs)serviceObj;
            return ArgTools.getString((IArgs)serviceArgs, (String)ARG_SERVICE_ADDRESS, null);
        }
        throw ExceptionTools.argumentInvalid((String)ARG_SERVICE_ADDRESS, null, null);
    }

    protected AisDevice basicCreateInstance(IArgs args) throws ObjectCreationException {
        return new AisDevice(this, this.getId(args));
    }

    protected void declareApplicationDescriptors(List<IApplicationDescriptor> apps) {
        super.declareApplicationDescriptors(apps);
        AisSignerFactory signerApp = new AisSignerFactory();
        signerApp.setDeviceProvider(this);
        signerApp.setLicenseAccountSupplier(() -> this.declareLicenseAccountSign());
        signerApp.setPolicy((IApplicationPolicy)new CommonSignerPolicy((CommonDeviceProvider)this));
        signerApp.setType(ISigner.class);
        apps.add((IApplicationDescriptor)signerApp);
        AisTimestampCreatorFactory timestampCreatorApp = new AisTimestampCreatorFactory();
        timestampCreatorApp.setDeviceProvider(this);
        timestampCreatorApp.setPolicy((IApplicationPolicy)new NoPolicy((CommonDeviceProvider)this));
        timestampCreatorApp.setType(ITimestampCreator.class);
        apps.add((IApplicationDescriptor)timestampCreatorApp);
    }

    protected ILicenseAccount declareLicenseAccountSignBasic() {
        ILicenseAccount account = this.getLicenseProduct().getAccount("de.intarsys.security.app.sign.account");
        account.setDefaultValueUnit(10, LicensePropertyUnit.PER_MINUTE);
        return account;
    }

    protected LicenseProduct declareLicenseProduct() {
        return LicenseTools.createProduct((Object)((Object)this), (String)"de.intarsys.security.device.ais");
    }

    @PostConstruct
    public void init() {
        super.init();
        DeviceProviderRegistry.get().registerDeviceProvider((IDeviceProvider)this);
    }
}

