/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.ais.etsi.app.signature;

import com.nimbusds.oauth2.sdk.id.Identifier;
import de.intarsys.etsi.rdsc.api.common.ErrorResponse;
import de.intarsys.etsi.rdsc.api.common.OperationMode;
import de.intarsys.etsi.rdsc.api.signatures.ConformanceLevel;
import de.intarsys.etsi.rdsc.api.signatures.DocumentDigests;
import de.intarsys.etsi.rdsc.api.signatures.SignDocRequest;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.app.signature.CommonBatchSigner;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.device.ais.etsi.app.signature.AisSignDocResponse;
import de.intarsys.security.device.ais.etsi.app.signature.AisSignerException;
import de.intarsys.security.device.ais.etsi.app.signature.Authorizer;
import de.intarsys.security.device.ais.etsi.app.signature.PACKAGE;
import de.intarsys.security.device.ais.etsi.app.signature.ValidationInfo;
import de.intarsys.security.device.ais.etsi.device.AisEtsiDevice;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.method.common.signature.SignatureOptions;
import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.ocsp.common.OCSPResponse;
import de.intarsys.security.signature.ValidationDataOptions;
import de.intarsys.security.signature.common.ExtendedSignatureData;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.etsi.api.SignatureFormat;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigestSupport;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AisEtsiSigner
extends CommonBatchSigner {
    public static final Collection<String> SUPPORTED_HASH_ALGORITHMS = List.of("SHA-256", "SHA-384", "SHA-512", "SHA3-256", "SHA3-384", "SHA3-512");
    private static final String ETSI_TS_119432_V1_1_1 = "http://uri.etsi.org/19432/v1.1.1#/creationprofile#";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Authorizer authorizer;
    private WebTarget signDocEndpoint;
    private String credentialId;

    public AisEtsiSigner(AisEtsiDevice device, Authorizer authorizer, WebTarget signDocEndpoint, String credentialId) {
        super((CommonDevice)device);
        this.authorizer = authorizer;
        this.signDocEndpoint = signDocEndpoint;
        this.credentialId = credentialId;
    }

    public boolean isBasic() {
        return false;
    }

    public Collection<String> getSupportedHashAlgorithmNames() {
        return SUPPORTED_HASH_ALGORITHMS;
    }

    public String getEncryptionAlgorithmName() {
        return null;
    }

    protected IConversation<?> basicSignAuthorized() {
        List<IDigest> digests = this.getDigestsToBeSigned();
        if (digests.isEmpty()) {
            return Conversation.completed(null);
        }
        this.logger.debug("Authorizing signature: credentialId={}, digests={}, authorizer={}", new Object[]{this.credentialId, digests, this.authorizer});
        return this.authorizer.authorizeSignature(this.credentialId, digests, this.getSignatureEvidence()).thenApply(Identifier::getValue).thenApply(sad -> this.sign((String)sad, digests)).thenAccept(x$0 -> this.tasksComplete((List)x$0));
    }

    private List<IDigest> getDigestsToBeSigned() {
        return this.getTasks().stream().map(task -> task.toBeSignedData).map(IDigestSupport::getDigest).toList();
    }

    private List<ISignatureData> sign(String sad, List<IDigest> digests) throws AisSignerException {
        String requestId = UUID.randomUUID().toString();
        DigestAlgorithm digestAlgorithm = this.determineDigestAlgorithm(digests);
        this.logger.debug("Creating remote signature: requestId={}, credentialId={}, digests={}", new Object[]{requestId, this.credentialId, digests});
        DocumentDigests documentDigests = new DocumentDigests();
        documentDigests.setHashAlgorithmOid(digestAlgorithm.getOid());
        documentDigests.setHashes(digests.stream().map(IDigest::getBytes).toList());
        SignDocRequest request = new SignDocRequest();
        request.setRequestId(requestId);
        request.setProfile(ETSI_TS_119432_V1_1_1);
        request.setOperationMode(OperationMode.SYNCHRONOUS);
        request.setCredentialId(this.credentialId);
        request.setSignatureFormat(this.determineSignatureFormat());
        request.setConformanceLevel(this.determineConformanceLevel());
        request.setDocumentDigests(documentDigests);
        request.setNumSignatures(Integer.valueOf(digests.size()));
        request.setSad(sad);
        AisSignDocResponse response = this.invokeRequest(request);
        List signatures = response.getDetachedSignatures();
        if (signatures == null || signatures.isEmpty()) {
            throw new AisSignerException(PACKAGE.Messages.getString("AisEtsiSigner.emptySignatureResponse", new Object[0]));
        }
        if (this.logger.isTraceEnabled()) {
            String signaturesString = signatures.stream().map(Base64.getEncoder()::encodeToString).collect(Collectors.joining(", "));
            this.logger.trace("Got signatures: requestId={}, signatures=[{}]", (Object)requestId, (Object)signaturesString);
        }
        IExtendedValidationData validationData = this.toExtendedValidationData(response.getValidationInfo());
        return signatures.stream().map(signatureBytes -> ExtendedSignatureData.create((byte[])signatureBytes, null, (IExtendedValidationData)validationData)).toList();
    }

    private de.intarsys.etsi.rdsc.api.signatures.SignatureFormat determineSignatureFormat() {
        SignatureFormat wanted = this.getSignatureFormat();
        if (wanted == null) {
            return null;
        }
        return switch (wanted) {
            case SignatureFormat.CAdES -> de.intarsys.etsi.rdsc.api.signatures.SignatureFormat.CADES;
            case SignatureFormat.PAdES -> de.intarsys.etsi.rdsc.api.signatures.SignatureFormat.PADES;
            case SignatureFormat.XAdES -> de.intarsys.etsi.rdsc.api.signatures.SignatureFormat.XADES;
            default -> throw new IllegalArgumentException("Unknown AdES family: " + wanted);
        };
    }

    private ConformanceLevel determineConformanceLevel() {
        boolean needsTimestamp;
        SignatureOptions options = this.getSignatureOptions();
        boolean bl = needsTimestamp = options.isAddTimestamp() && !options.hasTimestampCreator();
        if (needsTimestamp) {
            ValidationDataOptions validationOptions = options.getValidationDataOptions();
            boolean longTerm = validationOptions != null && validationOptions.isAddValidationData();
            return longTerm ? ConformanceLevel.B_LT : ConformanceLevel.B_T;
        }
        return ConformanceLevel.B_B;
    }

    private DigestAlgorithm determineDigestAlgorithm(Collection<IDigest> digests) throws AisSignerException {
        List<String> algorithmNames = digests.stream().map(IDigest::getAlgorithmName).distinct().toList();
        if (algorithmNames.size() != 1) {
            throw new AisSignerException(PACKAGE.Messages.getString("AisEtsiSigner.canOnlyUseOneHashAlgorithmPerRequest", new Object[0]));
        }
        String algorithmName = algorithmNames.get(0);
        DigestAlgorithm algorithm = DigestAlgorithm.lookupAlgorithm((String)algorithmName);
        if (algorithm == null) {
            throw new AisSignerException(PACKAGE.Messages.getString("AisEtsiSigner.unknownHashAlgorithm", new Object[]{algorithmName}));
        }
        return algorithm;
    }

    private AisSignDocResponse invokeRequest(SignDocRequest request) throws AisSignerException {
        try (Response response = this.signDocEndpoint.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).buildPost(Entity.json((Object)request)).invoke();){
            this.throwOnError(response);
            AisSignDocResponse aisSignDocResponse = (AisSignDocResponse)((Object)response.readEntity(AisSignDocResponse.class));
            return aisSignDocResponse;
        }
    }

    private void throwOnError(Response response) throws AisSignerException {
        Response.StatusType status = response.getStatusInfo();
        if (status.getFamily() == Response.Status.Family.SUCCESSFUL) {
            return;
        }
        try {
            ErrorResponse errorResponse = (ErrorResponse)response.readEntity(ErrorResponse.class);
            throw new AisSignerException(PACKAGE.Messages.getString("AisEtsiSigner.serviceError", new Object[]{errorResponse.getErrorDescription(), errorResponse.getErrorCode(), status.getStatusCode()}));
        }
        catch (ProcessingException exception) {
            throw new AisSignerException(PACKAGE.Messages.getString("AisEtsiSigner.unknownServiceError", new Object[]{status.getStatusCode()}), exception);
        }
    }

    private IExtendedValidationData toExtendedValidationData(ValidationInfo validationInfo) throws AisSignerException {
        if (validationInfo == null) {
            return null;
        }
        final List<IX509PublicKeyCertificate> certificates = this.decodeAll(validationInfo.getCertificates(), bytes -> {
            try {
                return X509CertificateFactory.get().createPublicKeyCertificate(bytes);
            }
            catch (CertificateException exception) {
                throw new AisSignerException(PACKAGE.Messages.getString("AisEtsiSigner.invalidCertificate", new Object[0]), exception);
            }
        });
        final List<IX509CRL> crls = this.decodeAll(validationInfo.getCrl(), bytes -> {
            try {
                return X509CertificateFactory.get().createCRL(bytes);
            }
            catch (CRLException exception) {
                throw new AisSignerException(PACKAGE.Messages.getString("AisEtsiSigner.invalidCrl", new Object[0]), exception);
            }
        });
        final List<IOCSPResponse> ocspResponses = this.decodeAll(validationInfo.getOcsp(), bytes -> {
            try {
                return new OCSPResponse(new BasicOCSPResp(BasicOCSPResponse.getInstance((Object)bytes)));
            }
            catch (RuntimeException exception) {
                throw new AisSignerException(PACKAGE.Messages.getString("AisEtsiSigner.invalidOcsp", new Object[0]), exception);
            }
        });
        return new IExtendedValidationData(){

            public Stream<IX509PublicKeyCertificate> getCertificates() {
                return certificates.stream();
            }

            public Stream<IOCSPResponse> getOCSPResponses() {
                return ocspResponses.stream();
            }

            public Stream<IX509CRL> getCRLs() {
                return crls.stream();
            }
        };
    }

    private <T> List<T> decodeAll(List<byte[]> inputs, Decoder<T> transformer) throws AisSignerException {
        if (inputs == null || inputs.isEmpty()) {
            return List.of();
        }
        ArrayList<T> outputs = new ArrayList<T>();
        for (byte[] bytes : inputs) {
            outputs.add(transformer.decode(bytes));
        }
        return outputs;
    }

    private static interface Decoder<T> {
        public T decode(byte[] var1) throws AisSignerException;
    }
}

