/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.ais.etsi.app.signature;

import de.intarsys.security.app.signature.CommonSignerFactory;
import de.intarsys.security.device.ais.etsi.app.signature.AisEtsiSigner;
import de.intarsys.security.device.ais.etsi.app.signature.Authorizer;
import de.intarsys.security.device.ais.etsi.device.AisEtsiDevice;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import jakarta.ws.rs.client.WebTarget;

public class AisEtsiSignerFactory
extends CommonSignerFactory<AisEtsiDevice, AisEtsiSigner> {
    public static final String ARG_SIGN_DOC_PATH = "signDocPath";
    public static final String ARG_CREDENTIAL_ID = "credentialId";
    public static final String ARG_AUTHORIZER = "authorizer";
    public static final String DEFAULT_SIGN_DOC_PATH = "etsi/standard/rdsc/v1/signatures/signDoc";

    protected AisEtsiSigner basicCreateApp(IArgs args) throws ObjectCreationException {
        AisEtsiDevice device = (AisEtsiDevice)this.getDevice(args);
        Authorizer authorizer = (Authorizer)InstanceSpec.getAsInstance((IArgs)args, (String)ARG_AUTHORIZER, Authorizer.class);
        if (authorizer == null) {
            throw ExceptionTools.argumentRequired((String)ARG_AUTHORIZER);
        }
        String credentialId = ArgTools.getString((IArgs)args, (String)ARG_CREDENTIAL_ID, null);
        if (credentialId == null || credentialId.isEmpty()) {
            throw ExceptionTools.argumentRequired((String)ARG_CREDENTIAL_ID);
        }
        String signDocPath = ArgTools.getString((IArgs)args, (String)ARG_SIGN_DOC_PATH, (String)DEFAULT_SIGN_DOC_PATH);
        WebTarget signDocEndpoint = device.getServiceEndpoint(signDocPath);
        return new AisEtsiSigner(device, authorizer, signDocEndpoint, credentialId);
    }

    public Class<AisEtsiSigner> getResultType() {
        return AisEtsiSigner.class;
    }
}

