/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.ais.etsi.app.signature;

import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerEndpointMetadata;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import de.intarsys.security.device.ais.etsi.app.signature.Authorizer;
import de.intarsys.security.device.ais.etsi.app.signature.IdentMethod;
import de.intarsys.security.device.ais.etsi.app.signature.LoginHint;
import de.intarsys.security.device.ais.etsi.app.signature.PushingRaxAuthorizer;
import de.intarsys.security.device.ais.etsi.app.signature.RaxAuthorizer;
import de.intarsys.security.device.ais.etsi.app.signature.SimpleRaxAuthorizer;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.factory.CommonInstantiatingFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.ssl.SslTools;
import java.io.IOException;
import java.net.URI;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;

public class AuthorizerFactory
extends CommonInstantiatingFactory<Authorizer> {
    private static final String ARG_SSL_CONTEXT = "sslContext";
    private static final String ARG_CALLBACK_URI = "callbackUri";
    private static final String ARG_CLIENT_ID = "clientId";
    private static final String ARG_CLIENT_SECRET = "clientSecret";
    private static final String ARG_SCOPE = "scope";
    private static final String ARG_ISSUER = "issuer";
    private static final String ARG_AUTHORIZATION_ENDPOINT = "authorizationEndpoint";
    private static final String ARG_TOKEN_ENDPOINT = "tokenEndpoint";
    private static final String ARG_PUSHED_AUTHORIZATION_REQUEST_ENDPOINT = "pushedAuthorizationRequestEndpoint";
    private static final String ARG_IDENT_METHOD = "identMethod";
    private static final String ARG_LOGIN_HINT = "loginHint";
    private static final String DEFAULT_SCOPE = "sign";
    private static final String MSISDN_NAMESPACE = "msisdn";
    private static final Pattern MSISDN_PATTERN = Pattern.compile("\\+?\\d{3,}");

    public Class<Authorizer> getResultType() {
        return Authorizer.class;
    }

    protected Authorizer basicCreateInstance(IArgs args) throws ObjectCreationException {
        RaxAuthorizer authorizer;
        SSLContext sslContext = SslTools.getSslContext((IArgs)args, (String)ARG_SSL_CONTEXT);
        if (sslContext == null) {
            throw new ObjectCreationException(String.format("Missing argument `%s`", ARG_SSL_CONTEXT));
        }
        String clientId = ArgTools.getString((IArgs)args, (String)ARG_CLIENT_ID, (String)"");
        if (clientId.isEmpty()) {
            throw new ObjectCreationException(String.format("Missing argument `%s`", ARG_CLIENT_ID));
        }
        Secret clientSecret = ArgTools.getSecretHide((IArgs)args, (String)ARG_CLIENT_SECRET, (Secret)Secret.EMPTY);
        if (clientSecret.isEmpty()) {
            throw new ObjectCreationException(String.format("Missing argument `%s`", ARG_CLIENT_SECRET));
        }
        String callback = ArgTools.getString((IArgs)args, (String)ARG_CALLBACK_URI, (String)"");
        String scope = ArgTools.getString((IArgs)args, (String)ARG_SCOPE, (String)DEFAULT_SCOPE);
        EndpointResolver endpointResolver = new EndpointResolver(args);
        URI authorizationEndpoint = endpointResolver.resolve(ARG_AUTHORIZATION_ENDPOINT, "authorization_endpoint", AuthorizationServerEndpointMetadata::getAuthorizationEndpointURI);
        URI tokenEndpoint = endpointResolver.resolve(ARG_TOKEN_ENDPOINT, "token_endpoint", AuthorizationServerEndpointMetadata::getTokenEndpointURI);
        IdentMethod identMethod = this.getIdentMethod(args);
        LoginHint loginHint = this.getLoginHint(args);
        if (identMethod != null && loginHint == null) {
            throw new ObjectCreationException(String.format("Argument `%s` implies pushed authorization, but argument `%s` is missing", ARG_IDENT_METHOD, ARG_LOGIN_HINT));
        }
        if (loginHint == null) {
            authorizer = new SimpleRaxAuthorizer();
        } else {
            authorizer = new PushingRaxAuthorizer();
            URI pushedAuthorizationRequestEndpoint = endpointResolver.resolve(ARG_PUSHED_AUTHORIZATION_REQUEST_ENDPOINT, "pushed_authorization_request_endpoint", AuthorizationServerEndpointMetadata::getPushedAuthorizationRequestEndpointURI);
            ((PushingRaxAuthorizer)authorizer).setPushedAuthorizationRequestEndpoint(pushedAuthorizationRequestEndpoint);
            ((PushingRaxAuthorizer)authorizer).setIdentMethod(identMethod);
            ((PushingRaxAuthorizer)authorizer).setLoginHint(loginHint);
        }
        authorizer.setSslContext(sslContext);
        authorizer.setCallbackUri(URI.create(callback));
        authorizer.setClientId(clientId);
        authorizer.setClientSecret(clientSecret);
        authorizer.setScope(Scope.parse((String)scope));
        authorizer.setAuthorizationEndpoint(authorizationEndpoint);
        authorizer.setTokenEndpoint(tokenEndpoint);
        return authorizer;
    }

    private IdentMethod getIdentMethod(IArgs args) {
        String type = ArgTools.getString((IArgs)args, (String)ARG_IDENT_METHOD, (String)"");
        return type.isEmpty() ? null : new IdentMethod(type);
    }

    private LoginHint getLoginHint(IArgs args) {
        String hint = ArgTools.getString((IArgs)args, (String)ARG_LOGIN_HINT, (String)"");
        if (hint.isEmpty()) {
            return null;
        }
        String namespace = MSISDN_NAMESPACE;
        Object identifier = hint;
        int index = hint.indexOf(58);
        if (index >= 0) {
            namespace = hint.substring(0, index);
            identifier = hint.substring(index + 1);
        }
        if (MSISDN_NAMESPACE.equals(namespace)) {
            if (!MSISDN_PATTERN.matcher((CharSequence)identifier).matches()) {
                throw new IllegalArgumentException("Invalid MSISDN login hint");
            }
            if (!((String)identifier).startsWith("+")) {
                identifier = "+" + (String)identifier;
            }
        }
        return new LoginHint(namespace, (String)identifier);
    }

    private static class EndpointResolver {
        private IArgs args;
        private AuthorizationServerMetadata authorizationServerMetadata;

        public EndpointResolver(IArgs args) {
            this.args = args;
        }

        public URI resolve(String argName, String paramName, Function<AuthorizationServerMetadata, URI> getter) throws ObjectCreationException {
            URI uri;
            String stringValue = ArgTools.getString((IArgs)this.args, (String)argName, (String)"");
            if (!stringValue.isEmpty()) {
                return URI.create(stringValue);
            }
            if (this.authorizationServerMetadata == null) {
                String issuer = ArgTools.getString((IArgs)this.args, (String)AuthorizerFactory.ARG_ISSUER, (String)"");
                if (issuer.isEmpty()) {
                    throw new ObjectCreationException(String.format("Missing argument `%s`; provide argument `%s` to query authorization server metadata", argName, AuthorizerFactory.ARG_ISSUER));
                }
                try {
                    this.authorizationServerMetadata = OIDCProviderMetadata.resolve((Issuer)new Issuer(issuer));
                }
                catch (GeneralException | IOException exception) {
                    throw new ObjectCreationException(String.format("Failed to query authorization server metadata to resolve `%s`", paramName));
                }
            }
            if ((uri = getter.apply(this.authorizationServerMetadata)) == null) {
                throw new ObjectCreationException(String.format("Missing argument `%s` or parameter `%s` in authorization server metadata", argName, paramName));
            }
            return uri;
        }
    }
}

