/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.ais.etsi.app.signature;

import com.nimbusds.common.contenttype.ContentType;
import com.nimbusds.oauth2.sdk.AbstractRequest;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.claims.SessionID;
import de.intarsys.security.device.ais.etsi.app.signature.IdentMethod;
import de.intarsys.security.device.ais.etsi.app.signature.LoginHint;
import java.net.URI;
import net.minidev.json.JSONObject;

public class PushedRaxAuthorizationRequest
extends AbstractRequest {
    private ClientAuthentication clientAuthentication;
    private ClientID clientId;
    private Secret clientSecret;
    private Scope scope;
    private IdentMethod identMethod;
    private LoginHint loginHint;
    private SessionID clientSessionId;
    private URI redirectUri;
    private JSONObject claims;

    public PushedRaxAuthorizationRequest(URI uri, ClientAuthentication clientAuthentication, ClientID clientId, Secret clientSecret, Scope scope, LoginHint loginHint, IdentMethod identMethod, SessionID clientSessionId, URI redirectUri, JSONObject claims) {
        super(uri);
        this.clientAuthentication = clientAuthentication;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.identMethod = identMethod;
        this.loginHint = loginHint;
        this.scope = scope;
        this.clientSessionId = clientSessionId;
        this.redirectUri = redirectUri;
        this.claims = claims;
    }

    public HTTPRequest toHTTPRequest() {
        JSONObject object = new JSONObject();
        if (this.clientId != null) {
            object.put((Object)"client_id", (Object)this.clientId.getValue());
        }
        if (this.clientSecret != null) {
            object.put((Object)"client_secret", (Object)this.clientSecret.getValue());
        }
        if (this.scope != null) {
            object.put((Object)"scope", (Object)this.scope.toString());
        }
        if (this.identMethod != null) {
            object.put((Object)"ident_method", (Object)this.identMethod.toJSONObject());
        }
        if (this.loginHint != null) {
            object.put((Object)"login_hint", (Object)this.loginHint.toJSONObject());
        }
        if (this.clientSessionId != null) {
            object.put((Object)"client_session_id", (Object)this.clientSessionId.getValue());
        }
        if (this.redirectUri != null) {
            object.put((Object)"redirect_uri", (Object)this.redirectUri.toString());
        }
        if (this.claims != null) {
            object.put((Object)"claims", (Object)this.claims);
        }
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getEndpointURI());
        httpRequest.setEntityContentType(ContentType.APPLICATION_JSON);
        httpRequest.setQuery(object.toJSONString());
        if (this.clientAuthentication != null) {
            this.clientAuthentication.applyTo(httpRequest);
        }
        return httpRequest;
    }
}

