/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.ais.etsi.app.signature;

import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.PushedAuthorizationResponse;
import com.nimbusds.oauth2.sdk.Request;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.claims.SessionID;
import de.intarsys.security.device.ais.etsi.app.signature.IdentMethod;
import de.intarsys.security.device.ais.etsi.app.signature.LoginHint;
import de.intarsys.security.device.ais.etsi.app.signature.PACKAGE;
import de.intarsys.security.device.ais.etsi.app.signature.PushedRaxAuthorizationRequest;
import de.intarsys.security.device.ais.etsi.app.signature.RaxAuthorizer;
import java.io.IOException;
import java.net.URI;
import net.minidev.json.JSONObject;

public class PushingRaxAuthorizer
extends RaxAuthorizer {
    private URI pushedAuthorizationRequestEndpoint;
    private IdentMethod identMethod;
    private LoginHint loginHint;

    public void setPushedAuthorizationRequestEndpoint(URI pushedAuthorizationRequestEndpoint) {
        this.pushedAuthorizationRequestEndpoint = pushedAuthorizationRequestEndpoint;
    }

    public void setIdentMethod(IdentMethod identMethod) {
        this.identMethod = identMethod;
    }

    public void setLoginHint(LoginHint loginHint) {
        this.loginHint = loginHint;
    }

    @Override
    protected AuthorizationRequest createAuthorizationRequest(String conversationHandle, JSONObject claims, Nonce nonce) throws GeneralException, IOException {
        PushedAuthorizationResponse pushedAuthorizationResponse;
        PushedRaxAuthorizationRequest pushedAuthorizationRequest = new PushedRaxAuthorizationRequest(this.pushedAuthorizationRequestEndpoint, this.createClientAuthentication(), this.getClientId(), new Secret(this.getClientSecretValue()), this.getScope(), this.loginHint, this.identMethod, new SessionID(conversationHandle), this.getCallbackUri(), claims);
        try {
            pushedAuthorizationResponse = this.httpRequestHandler.send((Request)pushedAuthorizationRequest, PushedAuthorizationResponse::parse);
        }
        catch (ParseException exception) {
            throw new GeneralException(PACKAGE.Messages.getString("PushingRaxAuthorizer.invalidPushedAuthorizationResponse", new Object[0]), (Throwable)exception);
        }
        if (!pushedAuthorizationResponse.indicatesSuccess()) {
            throw new GeneralException(this.getMessage("PushingRaxAuthorizer.pushedAuthorizationRequestFailed", pushedAuthorizationResponse.toErrorResponse().getErrorObject()));
        }
        return new AuthorizationRequest.Builder(ResponseType.CODE, this.getClientId()).endpointURI(this.getAuthorizationEndpoint()).requestURI(pushedAuthorizationResponse.toSuccessResponse().getRequestURI()).state(new State(conversationHandle)).customParameter("nonce", new String[]{nonce.toString()}).build();
    }

    @Override
    protected String getToStringDetails() {
        return String.format("%s, pushedAuthorizationRequestEndpoint=%s, identMethod=%s, loginHint=%s", super.getToStringDetails(), this.pushedAuthorizationRequestEndpoint, this.identMethod, this.loginHint);
    }
}

