/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.ais.etsi.app.signature;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.AuthorizationResponse;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Request;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.PKITLSClientAuthentication;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.app.signature.SignatureEvidence;
import de.intarsys.security.app.signature.SignatureItemEvidence;
import de.intarsys.security.device.ais.etsi.app.signature.Authorizer;
import de.intarsys.security.device.ais.etsi.app.signature.PACKAGE;
import de.intarsys.security.device.ais.util.Conversations;
import de.intarsys.security.device.ais.util.HttpRequestHandler;
import de.intarsys.tools.conversation.ConversationRegistry;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IReplyStage;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.conversation.impl.HttpRedirectStage;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.jaxrs.RequestContext;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RaxAuthorizer
implements Authorizer {
    private static final URI EMPTY_URI = URI.create("");
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final HttpRequestHandler httpRequestHandler = new HttpRequestHandler(this.logger);
    private SSLContext sslContext;
    private URI callbackUri;
    private Issuer issuer;
    private URI authorizationEndpoint;
    private URI tokenEndpoint;
    private ClientID clientId;
    private Secret clientSecret;
    private Scope scope;
    private AuthorizationServerMetadata authorizationServerMetadata;

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setCallbackUri(URI callbackUri) {
        this.callbackUri = callbackUri;
    }

    protected URI getCallbackUri() {
        if (this.isUndefined(this.callbackUri)) {
            return RequestContext.get().getUriBuilderContext().path("api/rax/callback").build(new Object[0]);
        }
        return this.callbackUri;
    }

    public void setIssuer(String issuer) {
        this.issuer = new Issuer(issuer);
    }

    protected Issuer getIssuer() {
        return this.issuer;
    }

    public void setAuthorizationEndpoint(URI authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    protected URI getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public void setTokenEndpoint(URI tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    protected URI getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void setClientId(String clientId) {
        this.clientId = new ClientID(clientId);
    }

    protected ClientID getClientId() {
        return this.clientId;
    }

    public void setClientSecret(Secret clientSecret) {
        this.clientSecret = clientSecret;
    }

    protected String getClientSecretValue() {
        try {
            return this.clientSecret.getString();
        }
        catch (GeneralSecurityException exception) {
            throw ExceptionTools.wrapWithMessage((Throwable)exception, (String)"Should never happen; if we were able to encode the secret, we should also be able to decode it");
        }
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    protected Scope getScope() {
        return this.scope;
    }

    @Override
    public IConversation<AccessToken> authorizeSignature(String credentialId, List<IDigest> digests, SignatureEvidence signatureEvidence) {
        AuthorizationRequest authorizationRequest;
        Conversation conversation = new Conversation("RAX/oauth2/auth (credential)");
        this.logger.debug("Beginning signature authorization: conversation={}, credentialId={}, digests={}", new Object[]{conversation.getHandle(), credentialId, digests});
        Nonce nonce = new Nonce();
        try {
            JSONObject claims = this.createClaims(credentialId, digests, signatureEvidence);
            authorizationRequest = this.createAuthorizationRequest(conversation.getHandle(), claims, nonce);
        }
        catch (GeneralException | IOException exception) {
            return Conversation.failed((Throwable)exception);
        }
        this.redirect((IConversation<?>)conversation, authorizationRequest.toURI());
        return conversation.thenApply(authorizationResponse -> this.createAuthorizationGrant((AuthorizationResponse)authorizationResponse, this.callbackUri)).thenApply(this::requestTokens).thenApply(arg_0 -> this.lambda$authorizeSignature$1((IConversation)conversation, arg_0));
    }

    protected AuthorizationServerMetadata getAuthorizationServerMetadata() throws GeneralException, IOException {
        if (this.authorizationServerMetadata == null) {
            this.authorizationServerMetadata = OIDCProviderMetadata.resolve((Issuer)this.issuer);
        }
        return this.authorizationServerMetadata;
    }

    protected boolean isUndefined(URI uri) {
        return uri == null || uri.equals(EMPTY_URI);
    }

    private JSONObject createClaims(String credentialId, List<IDigest> digests, SignatureEvidence signatureEvidence) {
        DigestAlgorithm digestAlgorithm;
        JSONObject claims = new JSONObject();
        if (credentialId != null) {
            claims.put((Object)"credentialID", (Object)credentialId);
        }
        if ((digestAlgorithm = this.getDigestAlgorithm(digests)) != null) {
            claims.put((Object)"hashAlgorithmOID", (Object)digestAlgorithm.getOid());
        }
        List evidenceItems = signatureEvidence == null ? List.of() : signatureEvidence.getItems();
        ArrayList<JSONObject> documentDigests = new ArrayList<JSONObject>();
        int index = 0;
        for (IDigest digest : digests) {
            String hash = Base64.getEncoder().encodeToString(digest.getBytes());
            String label = index < evidenceItems.size() ? ((SignatureItemEvidence)evidenceItems.get(index)).getLabel() : this.getMessage("RaxAuthorizer.documentLabel", index + 1);
            documentDigests.add(new JSONObject().appendField("hash", (Object)hash).appendField("label", (Object)label));
            ++index;
        }
        claims.put((Object)"documentDigests", documentDigests);
        return claims;
    }

    private DigestAlgorithm getDigestAlgorithm(List<IDigest> digests) {
        if (digests.isEmpty()) {
            return null;
        }
        String algorithmName = digests.get(0).getAlgorithmName();
        return DigestAlgorithm.lookupAlgorithm((String)algorithmName);
    }

    private AuthorizationGrant createAuthorizationGrant(AuthorizationResponse authorizationResponse, URI callbackUri) throws GeneralException {
        if (authorizationResponse.indicatesSuccess()) {
            AuthorizationCode code = authorizationResponse.toSuccessResponse().getAuthorizationCode();
            return new AuthorizationCodeGrant(code, callbackUri);
        }
        ErrorObject error = authorizationResponse.toErrorResponse().getErrorObject();
        throw new GeneralException(this.getMessage("RaxAuthorizer.signatureAuthorizationFailed", error), error);
    }

    protected abstract AuthorizationRequest createAuthorizationRequest(String var1, JSONObject var2, Nonce var3) throws GeneralException, IOException;

    private void redirect(IConversation<?> conversation, URI destination) {
        Conversations.setRedirection(conversation, destination);
        conversation.setReplyStage((IReplyStage)new HttpRedirectStage(destination, false, false));
        ConversationRegistry.publishForLifetime(conversation);
        this.logger.trace("Redirected conversation {} to {}", conversation, (Object)destination);
    }

    private OIDCTokens requestTokens(AuthorizationGrant authorizationGrant) throws IOException, GeneralException {
        OIDCTokenResponse tokenResponse;
        this.logger.trace("Requesting token");
        Map<String, List<String>> customParams = Map.of("client_secret", List.of(this.getClientSecretValue()));
        TokenRequest tokenRequest = new TokenRequest(this.tokenEndpoint, this.createClientAuthentication(), authorizationGrant, null, null, customParams);
        try {
            tokenResponse = this.httpRequestHandler.send((Request)tokenRequest, this::parseOidcTokenResponse);
        }
        catch (ParseException exception) {
            throw new GeneralException(this.getMessage("RaxAuthorizer.invalidTokenResponse", new Object[0]), (Throwable)exception);
        }
        if (tokenResponse.indicatesSuccess()) {
            return tokenResponse.toSuccessResponse().getOIDCTokens();
        }
        ErrorObject error = tokenResponse.toErrorResponse().getErrorObject();
        throw new GeneralException(this.getMessage("RaxAuthorizer.tokenRequestFailed", error));
    }

    private OIDCTokenResponse parseOidcTokenResponse(HTTPResponse httpResponse) throws ParseException {
        httpResponse.ensureStatusCode(new int[]{200, 201});
        JSONObject jsonObject = httpResponse.getContentAsJSONObject();
        return OIDCTokenResponse.parse((JSONObject)jsonObject);
    }

    protected ClientAuthentication createClientAuthentication() {
        return new PKITLSClientAuthentication(this.clientId, this.sslContext.getSocketFactory());
    }

    protected String getMessage(String messageKey, ErrorObject error) {
        String description;
        String message = this.getMessage(messageKey, new Object[0]);
        if (error == null) {
            return message;
        }
        String code = error.getCode();
        if (code == null || code.isEmpty()) {
            code = "unknown";
        }
        return (description = error.getDescription()) == null || description.isEmpty() ? String.format("%s (%s)", message, code) : String.format("%s: %s (%s)", message, description, code);
    }

    protected String getMessage(String messageKey, Object ... arguments) {
        return PACKAGE.Messages.getString(messageKey, arguments);
    }

    public String toString() {
        return String.format("%s(%s)", this.getClass().getSimpleName(), this.getToStringDetails());
    }

    protected String getToStringDetails() {
        return String.format("clientId=%s, clientSecret=*, scope=%s, issuer=%s, authorizationEndpoint=%s, tokenEndpoint=%s, callbackUri=%s)", this.clientId, this.scope, this.issuer, this.authorizationEndpoint, this.tokenEndpoint, this.callbackUri);
    }

    private /* synthetic */ AccessToken lambda$authorizeSignature$1(IConversation conversation, OIDCTokens tokens) throws RuntimeException {
        this.logger.debug("Signature authorized successfully: conversation={}", (Object)conversation.getHandle());
        return tokens.getAccessToken();
    }
}

