/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.ais.etsi.app.signature;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.TypelessAccessToken;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.app.signature.SignatureEvidence;
import de.intarsys.security.device.ais.etsi.app.signature.Authorizer;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.digest.IDigest;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import net.minidev.json.JSONObject;

public class RaxTestAuthorizer
implements Authorizer {
    private String issuer;
    private String subject;
    private String audience;
    private String givenName;
    private String surname;
    private String country;

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    @Override
    public IConversation<AccessToken> authorizeSignature(String credentialId, List<IDigest> digests, SignatureEvidence signatureEvidence) {
        String sad = this.createSad(credentialId, digests);
        return Conversation.completed((Object)new TypelessAccessToken(sad));
    }

    private String createSad(String credentialId, List<IDigest> digests) {
        JSONObject sci = this.createSignatureCreationInformation(credentialId, digests);
        Instant now = Instant.now();
        UUID uuid = UUID.randomUUID();
        JWTClaimsSet claims = new JWTClaimsSet.Builder().claim("active", (Object)true).issuer(this.issuer).subject(this.subject).audience(this.audience).claim("given_name", (Object)this.givenName).claim("surname", (Object)this.surname).claim("country_code", (Object)this.country).issueTime(Date.from(now)).notBeforeTime(Date.from(now)).expirationTime(Date.from(now.plus(1L, ChronoUnit.HOURS))).claim("structured_scope", (Object)new JSONObject().appendField("sign", (Object)sci)).claim("consentSerialNumber", (Object)("csn-" + uuid)).claim("serialNumber", (Object)("sn-" + uuid)).claim("evidence_id", (Object)("ev-" + uuid)).claim("txn", (Object)("txn-" + uuid)).build();
        return new PlainJWT(claims).serialize();
    }

    private JSONObject createSignatureCreationInformation(String credentialId, List<IDigest> digests) {
        JSONObject sci = new JSONObject();
        sci.put((Object)"type", (Object)"sign");
        if (credentialId != null) {
            sci.put((Object)"credentialID", (Object)credentialId);
        }
        if (digests != null && !digests.isEmpty()) {
            String algorithmName = digests.get(0).getAlgorithmName();
            DigestAlgorithm digestAlgorithm = DigestAlgorithm.lookupAlgorithm((String)algorithmName);
            if (digestAlgorithm != null) {
                sci.put((Object)"hashAlgorithmOID", (Object)digestAlgorithm.getOid());
            }
            ArrayList<JSONObject> documentDigests = new ArrayList<JSONObject>();
            int i = 0;
            for (IDigest digest : digests) {
                documentDigests.add(new JSONObject().appendField("label", (Object)String.format("Hash #%d", i)).appendField("hash", (Object)Base64.getEncoder().encodeToString(digest.getBytes())));
                ++i;
            }
            sci.put((Object)"documentDigests", documentDigests);
        }
        return sci;
    }
}

