/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.ais.etsi.device;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.util.JacksonFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.intarsys.security.device.ais.etsi.device.AisEtsiDeviceProvider;
import de.intarsys.security.device.ais.util.HttpConfiguration;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.ext.ContextResolver;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.logging.LoggingFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AisEtsiDevice
extends CommonDevice<AisEtsiDeviceProvider> {
    public static final String ARG_HTTP_CONFIGURATION = "httpConfiguration";
    public static final String ARG_SERVICE_URI = "serviceUri";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private HttpConfiguration httpConfiguration;
    private String serviceUri;
    private Client client;

    protected AisEtsiDevice(AisEtsiDeviceProvider deviceProvider, String name) {
        super((CommonDeviceProvider)deviceProvider, name);
    }

    public void configure(IArgs args) throws Exception {
        super.configure(args);
        this.httpConfiguration = HttpConfiguration.from(args, ARG_HTTP_CONFIGURATION);
        this.serviceUri = ArgTools.getString((IArgs)args, (String)ARG_SERVICE_URI, null);
        if (this.serviceUri == null) {
            throw ExceptionTools.argumentRequired((String)ARG_SERVICE_URI);
        }
    }

    protected void logConfiguration() {
        super.logConfiguration();
        this.logger.info("  +-- httpConfiguration: {}", (Object)this.httpConfiguration);
        this.logger.info("  +-- serviceUri: {}", (Object)this.serviceUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebTarget getServiceEndpoint(String path) {
        Object object = this.lock;
        synchronized (object) {
            if (this.client == null) {
                this.client = this.createClient(this.httpConfiguration);
            }
        }
        return this.client.target(this.serviceUri).path(path);
    }

    private Client createClient(HttpConfiguration configuration) {
        SSLContext sslContext;
        HostnameVerifier hostnameVerifier;
        LoggingFeature logging = new LoggingFeature(java.util.logging.Logger.getLogger(((Object)((Object)this)).getClass().getName()), Level.FINEST, LoggingFeature.Verbosity.PAYLOAD_TEXT, Integer.valueOf(8192));
        ContextResolver<ObjectMapper> objectMapperProvider = new ContextResolver<ObjectMapper>(){

            public ObjectMapper getContext(Class<?> type) {
                return new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
            }
        };
        ClientBuilder builder = ClientBuilder.newBuilder().withConfig((Configuration)new ClientConfig().register((Object)logging).register((Object)objectMapperProvider).register(JacksonFeature.class)).connectTimeout(configuration.getConnectTimeout(), TimeUnit.MILLISECONDS).readTimeout(configuration.getReadTimeout(), TimeUnit.MILLISECONDS);
        if (configuration.isUseProxy()) {
            String proxyHost = System.getProperty("http.proxyHost");
            if (proxyHost == null) {
                this.logger.error("Proxy enabled, but system property http.proxyHost is not set; continuing without proxy");
            } else {
                String proxyScheme = proxyHost.startsWith("http") ? "" : "http://";
                String proxyPort = System.getProperty("http.proxyPort");
                String proxyUri = proxyPort == null ? proxyScheme + proxyHost : proxyScheme + proxyHost + ":" + proxyPort;
                String proxyUser = System.getProperty("http.proxyUser");
                String proxyPassword = System.getProperty("http.proxyPassword");
                ((ClientBuilder)((ClientBuilder)((ClientBuilder)builder.property("jersey.config.client.proxy.uri", (Object)proxyUri)).property("jersey.config.client.proxy.username", (Object)proxyUser)).property("jersey.config.client.proxy.password", (Object)proxyPassword)).property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.BUFFERED);
            }
        }
        if ((hostnameVerifier = configuration.getHostnameVerifier()) != null) {
            builder.hostnameVerifier(hostnameVerifier);
        }
        if ((sslContext = configuration.getSslContext()) != null) {
            builder.sslContext(sslContext);
        }
        return builder.build();
    }
}

