/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.ais.etsi.device;

import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.app.IApplicationPolicy;
import de.intarsys.security.app.signature.CommonSignerPolicy;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.device.DeviceProviderRegistry;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.ais.etsi.app.signature.AisEtsiSignerFactory;
import de.intarsys.security.device.ais.etsi.device.AisEtsiDevice;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.LicenseProduct;
import de.intarsys.tools.license.LicensePropertyUnit;
import de.intarsys.tools.license.LicenseTools;
import jakarta.annotation.PostConstruct;
import java.util.List;

public class AisEtsiDeviceProvider
extends CommonDeviceProvider<AisEtsiDevice> {
    private static final String LIC_PRODUCT = "de.intarsys.security.device.ais";

    @PostConstruct
    public void init() {
        super.init();
        DeviceProviderRegistry.get().registerDeviceProvider((IDeviceProvider)this);
    }

    protected AisEtsiDevice basicCreateInstance(IArgs args) {
        return new AisEtsiDevice(this, this.getId(args));
    }

    protected LicenseProduct declareLicenseProduct() {
        return LicenseTools.createProduct((Object)((Object)this), (String)LIC_PRODUCT);
    }

    protected void declareApplicationDescriptors(List<IApplicationDescriptor> applications) {
        super.declareApplicationDescriptors(applications);
        AisEtsiSignerFactory signerFactory = new AisEtsiSignerFactory();
        signerFactory.setDeviceProvider(this);
        signerFactory.setType(ISigner.class);
        signerFactory.setPolicy((IApplicationPolicy)new CommonSignerPolicy((CommonDeviceProvider)this));
        signerFactory.setLicenseAccountSupplier(() -> this.declareLicenseAccountSign());
        applications.add((IApplicationDescriptor)signerFactory);
    }

    protected ILicenseAccount declareLicenseAccountSignBasic() {
        ILicenseAccount account = this.getLicenseProduct().getAccount("de.intarsys.security.app.sign.account");
        account.setDefaultValueUnit(10, LicensePropertyUnit.PER_MINUTE);
        return account;
    }
}

