/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.ais.rax;

import com.nimbusds.oauth2.sdk.AuthorizationResponse;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.State;
import de.intarsys.security.device.ais.util.Conversations;
import de.intarsys.tools.conversation.ConversationExpired;
import de.intarsys.tools.conversation.ConversationRegistry;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.service.impl.ConversationServiceTools;
import de.intarsys.tools.jaxrs.JaxrsTools;
import de.intarsys.tools.jaxrs.Stateful;
import de.intarsys.tools.loadbalance.LoadBalanced;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="rax")
public class SvcRaxCallback {
    public static final String CALLBACK_PATH = "api/rax/callback";
    private static final String FALLBACK_REDIRECTION_PATH = "rax/done.html";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @GET
    @Path(value="callback")
    public Response callback(@Context HttpServletRequest request, @Context UriInfo uriInfo) {
        IConversation conversation;
        AuthorizationResponse authorizationResponse;
        try {
            authorizationResponse = AuthorizationResponse.parse((URI)uriInfo.getRequestUri());
        }
        catch (ParseException exception) {
            throw new BadRequestException("Invalid authorization response", (Throwable)exception);
        }
        State state = authorizationResponse.getState();
        if (state == null) {
            throw new BadRequestException("Invalid authorization response: missing required 'state'");
        }
        try {
            conversation = ConversationRegistry.get().getConversation(state.getValue());
        }
        catch (ConversationExpired exception) {
            throw new NotFoundException("Unexpected authorization response", (Throwable)exception);
        }
        URI integrationRedirection = ConversationServiceTools.getRedirectUriExpanded((IConversation)conversation);
        Conversations.removeRedirection(conversation);
        conversation.complete((Object)authorizationResponse);
        URI redirection = Conversations.getRedirection(conversation);
        if (redirection == null && (redirection = integrationRedirection) == null) {
            redirection = JaxrsTools.getUriBuilderContext((HttpServletRequest)request).path(FALLBACK_REDIRECTION_PATH).build(new Object[0]);
        }
        this.logger.trace("Redirecting conversation {} to {}", (Object)conversation, (Object)redirection);
        return Response.seeOther((URI)redirection).build();
    }
}

