/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.ais.util;

import com.nimbusds.common.contenttype.ContentType;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Request;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import de.intarsys.security.device.ais.util.HttpResponseParser;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class HttpRequestHandler {
    private final Logger logger;
    private final AtomicInteger count = new AtomicInteger();

    public HttpRequestHandler(Logger logger) {
        this.logger = logger;
    }

    public <R> R send(Request request, HttpResponseParser<R> parser) throws IOException, ParseException {
        return this.send(request, null, parser);
    }

    public <R> R send(Request request, ContentType accept, HttpResponseParser<R> parser) throws IOException, ParseException {
        HTTPRequest httpRequest = request.toHTTPRequest();
        if (accept != null) {
            httpRequest.setAccept(accept.toString());
        }
        int n = this.count.incrementAndGet();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Sending HTTP request\n{}", (Object)this.formatHttpMessage(String.format("%d> ", n), String.format("%s %s", httpRequest.getMethod(), httpRequest.getURI()), httpRequest.getHeaderMap(), httpRequest.getQuery()));
        }
        HTTPResponse httpResponse = httpRequest.send();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Received HTTP response\n{}", (Object)this.formatHttpMessage(String.format("%d< ", n), httpResponse.getStatusCode(), httpResponse.getHeaderMap(), httpResponse.getContent()));
        }
        return parser.parse(httpResponse);
    }

    private String formatHttpMessage(String prefix, Object subject, Map<String, List<String>> headers, String body) {
        StringBuilder text = new StringBuilder(prefix).append(subject).append('\n');
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            text.append(prefix).append(entry.getKey()).append(": ");
            List<String> values = entry.getValue();
            if (values != null && !values.isEmpty()) {
                if (values.size() == 1) {
                    text.append(values.get(0));
                } else {
                    text.append(values);
                }
            }
            text.append('\n');
        }
        if (body != null) {
            text.append(body).append('\n');
        }
        return text.toString();
    }
}

