/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.type.xml;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.impl.ExtensionPointHandlerAdapter;
import de.intarsys.document.type.xml.XMLEnvironment;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class EntityInstaller
extends ExtensionPointHandlerAdapter {
    private static final Logger Log = LoggerFactory.getLogger(EntityInstaller.class);
    public static final String XE_ENTITY = "entity";
    public static final String ATTR_PUBLICID = "publicId";
    public static final String ATTR_PATH = "path";

    protected Object basicInstallInsert(IExtension extension, IElement element) {
        File dtdFile;
        String publicId;
        if (XE_ENTITY.equals(element.getName())) {
            publicId = element.attributeValue(ATTR_PUBLICID, null);
            String path = element.attributeValue(ATTR_PATH, null);
            if (StringTools.isEmpty((String)path)) {
                String msg = "entity '" + publicId + "' must provide a 'path' to be loaded";
                this.log(Log, Level.ERROR, extension, element, msg, null);
                return null;
            }
            dtdFile = new File(path);
            if (!dtdFile.isFile()) {
                String msg = "entity '" + publicId + "' - path '" + path + "' doesn't point to a file";
                this.log(Log, Level.ERROR, extension, element, msg, null);
                return null;
            }
        } else {
            return super.basicInstallInsert(extension, element);
        }
        XMLEnvironment.get().registerEntity(publicId, (ILocator)new FileLocator(dtdFile));
        return null;
    }
}

