/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.type.xml;

import de.intarsys.tools.file.FileLoader;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class SchemaSet
implements LSResourceResolver {
    private static final Logger Log = LoggerFactory.getLogger(SchemaSet.class);
    private final String name;
    private final File schemaDir;
    private final String root;

    public SchemaSet(String name, File schemaDir, String root) {
        this.name = name;
        this.schemaDir = schemaDir;
        this.root = root;
    }

    public String getName() {
        return this.name;
    }

    public Source[] getSources() throws IOException {
        return new SchemaFinder().getSchemaSources();
    }

    private String resolveFileName(String baseURI, String systemId) {
        String parent;
        Object filename = "";
        if (baseURI.toLowerCase().startsWith("http://") && (parent = new File(baseURI.substring(7)).getParent()) != null) {
            filename = parent + File.separator;
        }
        return (String)filename + this.systemIdToFileName(systemId);
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        String filename = this.resolveFileName(baseURI, systemId);
        File file = new File(this.schemaDir, filename);
        if (file.canRead() && file.isFile()) {
            SchemaLSInput lsInput = new SchemaLSInput(publicId, systemId, baseURI);
            try {
                lsInput.setByteStream(new FileInputStream(file));
                return lsInput;
            }
            catch (FileNotFoundException e) {
                Log.warn(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        Log.warn("failed resolving schema type '" + type + "', namespaceURI '" + namespaceURI + "', baseURI '" + baseURI + "', systemId '" + systemId + "'");
        return null;
    }

    private String systemIdToFileName(String systemId) {
        if (systemId.startsWith("http://")) {
            return systemId.substring(7);
        }
        return systemId;
    }

    class SchemaFinder
    extends FileLoader {
        private final ArrayList<Source> xsdSources = new ArrayList();

        protected boolean basicLoadFile(File file, boolean readOnly, String path) {
            if (file.getName().toLowerCase().endsWith(".xsd")) {
                this.xsdSources.add(new StreamSource(file));
            }
            return true;
        }

        public Source[] getSchemaSources() throws IOException {
            this.xsdSources.clear();
            if (StringTools.isEmpty((String)SchemaSet.this.root)) {
                this.load(SchemaSet.this.schemaDir, true, true);
            } else {
                this.load(SchemaSet.this.schemaDir, SchemaSet.this.root, true, false);
            }
            return this.xsdSources.toArray(new Source[this.xsdSources.size()]);
        }
    }

    static class SchemaLSInput
    implements LSInput {
        private String publicId;
        private String systemId;
        private String baseURI;
        private String encoding;
        private String stringData;
        private Reader characterStream;
        private boolean certifiedText;
        private InputStream byteStream;

        public SchemaLSInput(String publicId, String systemId, String baseURI) {
            this.publicId = publicId;
            this.systemId = systemId;
            this.baseURI = baseURI;
        }

        @Override
        public String getBaseURI() {
            return this.baseURI;
        }

        @Override
        public InputStream getByteStream() {
            return new InputStream(){

                @Override
                public void close() throws IOException {
                    byteStream.close();
                }

                @Override
                public int read() throws IOException {
                    return byteStream.read();
                }
            };
        }

        @Override
        public boolean getCertifiedText() {
            return this.certifiedText;
        }

        @Override
        public Reader getCharacterStream() {
            return this.characterStream;
        }

        @Override
        public String getEncoding() {
            return this.encoding;
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public String getStringData() {
            return this.stringData;
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setBaseURI(String baseURI) {
            this.baseURI = baseURI;
        }

        @Override
        public void setByteStream(InputStream byteStream) {
            this.byteStream = byteStream;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
            this.certifiedText = certifiedText;
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
            this.characterStream = characterStream;
        }

        @Override
        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        @Override
        public void setStringData(String stringData) {
            this.stringData = stringData;
        }

        @Override
        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }
    }
}

