/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.type.xml;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.impl.ExtensionPointHandlerAdapter;
import de.intarsys.document.model.DocumentOutlet;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.document.type.xml.SchemaSet;
import de.intarsys.document.type.xml.XMLDocumentType;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.proxy.IProxy;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class SchemaSetInstaller
extends ExtensionPointHandlerAdapter {
    private static final Logger Log = LoggerFactory.getLogger(SchemaSetInstaller.class);
    public static final String XE_SCHEMASET = "schemaset";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_ROOT = "root";
    public static final String ATTR_PATH = "path";

    protected Object basicInstallInsert(IExtension extension, IElement element) {
        File schemaDir;
        String schemaSetName;
        if (XE_SCHEMASET.equals(element.getName())) {
            schemaSetName = element.attributeValue(ATTR_NAME, null);
            String path = element.attributeValue(ATTR_PATH, null);
            if (StringTools.isEmpty((String)path)) {
                String msg = "schema set '" + schemaSetName + "' must provide a 'path' to be loaded";
                this.log(Log, Level.ERROR, extension, element, msg, null);
                return null;
            }
            schemaDir = new File(path);
            if (!schemaDir.canRead()) {
                String msg = "schema set '" + schemaSetName + "' - path '" + path + "' cannot be read";
                this.log(Log, Level.ERROR, extension, element, msg, null);
                return null;
            }
            if (StringTools.isEmpty((String)schemaSetName)) {
                schemaSetName = schemaDir.getName();
            }
        } else {
            return super.basicInstallInsert(extension, element);
        }
        String root = element.attributeValue(ATTR_ROOT, null);
        this.registerSchemaSet(new SchemaSet(schemaSetName, schemaDir, root));
        return null;
    }

    private void registerSchemaSet(SchemaSet schemaSet) {
        IDocumentType docType = DocumentOutlet.get().lookupDocumentType(XMLDocumentType.ID);
        XMLDocumentType xmlDocType = docType instanceof IProxy ? (XMLDocumentType)((IProxy)docType).getRealized() : (XMLDocumentType)docType;
        xmlDocType.addSchemaSet(schemaSet);
    }
}

